/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.datahub;

import io.intino.alexandria.event.Event;
import io.intino.alexandria.event.EventHub;
import io.intino.cesar.datahub.events.ProcessLog;
import io.intino.cesar.datahub.events.ProcessStatus;
import io.intino.cesar.datahub.events.ServerBoot;
import io.intino.cesar.datahub.events.ServerInfo;
import io.intino.cesar.datahub.events.ServerLog;
import io.intino.cesar.datahub.events.ServerStatus;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

public class ConsulTerminal {
    private final EventHub eventHub;
    private Map<Consumer<?>, Consumer<Event>> consumers = new HashMap();
    public static String[] subscriptionChannels = new String[0];

    public ConsulTerminal(EventHub eventHub) {
        this.eventHub = eventHub;
    }

    public void publish(Object event, String context) {
        if (event instanceof ProcessLog) {
            this.publish((ProcessLog)event);
        }
        if (event instanceof ProcessStatus) {
            this.publish((ProcessStatus)event);
        }
        if (event instanceof ServerBoot) {
            this.publish((ServerBoot)event);
        }
        if (event instanceof ServerInfo) {
            this.publish((ServerInfo)event);
        }
        if (event instanceof ServerLog) {
            this.publish((ServerLog)event);
        }
        if (event instanceof ServerStatus) {
            this.publish((ServerStatus)event);
        }
    }

    public void publish(ProcessLog processLog) {
        this.eventHub.sendEvent("consul.process.ProcessLog", processLog);
    }

    public void publish(ProcessStatus processStatus) {
        this.eventHub.sendEvent("consul.process.ProcessStatus", processStatus);
    }

    public void publish(ServerBoot serverBoot) {
        this.eventHub.sendEvent("consul.server.ServerBoot", serverBoot);
    }

    public void publish(ServerInfo serverInfo) {
        this.eventHub.sendEvent("consul.server.ServerInfo", serverInfo);
    }

    public void publish(ServerLog serverLog) {
        this.eventHub.sendEvent("consul.server.ServerLog", serverLog);
    }

    public void publish(ServerStatus serverStatus) {
        this.eventHub.sendEvent("consul.server.ServerStatus", serverStatus);
    }

    public void stop() {
    }

    public static interface ServerStatusConsumer
    extends Consumer<ServerStatus> {
    }

    public static interface ServerBootConsumer
    extends Consumer<ServerBoot> {
    }

    public static interface ServerLogConsumer
    extends Consumer<ServerLog> {
    }

    public static interface ServerInfoConsumer
    extends Consumer<ServerInfo> {
    }

    public static interface ProcessStatusConsumer
    extends Consumer<ProcessStatus> {
    }

    public static interface ProcessLogConsumer
    extends Consumer<ProcessLog> {
    }
}

