/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.zim;

import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.message.Message;
import io.intino.alexandria.message.MessageReader;
import io.intino.alexandria.zim.ZimStream;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;

public class ZimReader
implements ZimStream {
    public static final String ZimExtension = ".zim";
    private final Iterator<Message> iterator;
    private Message current;

    public ZimReader(File file) {
        this(ZimReader.iteratorOf(ZimReader.inputStream(file)));
    }

    public ZimReader(InputStream is) {
        this(ZimReader.iteratorOf(is instanceof GZIPInputStream ? is : ZimReader.zipStreamOf(is)));
    }

    public ZimReader(String text) {
        this(ZimReader.iteratorOf(new ByteArrayInputStream(text.getBytes())));
    }

    public ZimReader(Message ... messages) {
        this(Arrays.stream(messages));
    }

    public ZimReader(List<Message> messages) {
        this(messages.stream());
    }

    public ZimReader(Stream<Message> stream) {
        this(stream.iterator());
    }

    public ZimReader(Iterator<Message> iterator) {
        this.iterator = iterator;
    }

    public Iterator<Message> iterator() {
        return this.iterator;
    }

    @Override
    public Message current() {
        return this.current;
    }

    @Override
    public Message next() {
        this.current = this.iterator.hasNext() ? this.iterator.next() : null;
        return this.current;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    private static Iterator<Message> iteratorOf(InputStream is) {
        final MessageReader source = ZimReader.readerOf(is);
        return new Iterator<Message>(){
            private Message current;
            private Message next;

            @Override
            public Message next() {
                if (this.current == this.next) {
                    this.hasNext();
                }
                this.current = this.next;
                return this.current;
            }

            private Message nextMessageFromSource() {
                return source.next();
            }

            @Override
            public boolean hasNext() {
                boolean hasNext;
                if (this.current != this.next) {
                    return true;
                }
                this.next = this.nextMessageFromSource();
                boolean bl = hasNext = this.next != null;
                if (!hasNext) {
                    this.close();
                }
                return hasNext;
            }

            void close() {
                source.close();
            }
        };
    }

    private static MessageReader readerOf(InputStream is) {
        return new MessageReader(is);
    }

    private static InputStream inputStream(File file) {
        try {
            return ZimReader.zipStreamOf(file);
        }
        catch (IOException e) {
            return new ByteArrayInputStream(new byte[0]);
        }
    }

    private static InputStream zipStreamOf(File file) throws IOException {
        return new GZIPInputStream(ZimReader.fileInputStream(file));
    }

    private static InputStream zipStreamOf(InputStream stream) {
        try {
            return new GZIPInputStream(stream);
        }
        catch (IOException e) {
            Logger.error(e);
            return stream;
        }
    }

    private static BufferedInputStream fileInputStream(File file) throws FileNotFoundException {
        return new BufferedInputStream(new FileInputStream(file));
    }
}

