/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.rest.spark;

import io.intino.alexandria.rest.spark.RequestAdapter;
import java.io.InputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Collection;

public class SparkReader {
    public static <T> T read(String object, Type type) {
        if (object == null) {
            return null;
        }
        Class rawType = (Class)((ParameterizedType)type).getRawType();
        if (Collection.class.isAssignableFrom(rawType)) {
            return SparkReader.readList(object, type);
        }
        return SparkReader.read(object, rawType);
    }

    public static <T> T read(String object, Class<T> type) {
        if (object == null) {
            return null;
        }
        if (type.isAssignableFrom(Error.class) || Collection.class.isAssignableFrom(type)) {
            return RequestAdapter.adaptFromJSON(object, type);
        }
        if (type.isAssignableFrom(byte[].class)) {
            return (T)SparkReader.readBytes(object);
        }
        return RequestAdapter.adapt(object, type);
    }

    public static <T> T read(Object object, Class<T> type) {
        if (object == null) {
            return null;
        }
        return (T)(type.isAssignableFrom(InputStream.class) ? object : null);
    }

    private static <T> T readList(String object, Type type) {
        return RequestAdapter.adaptFromJSON(object, type);
    }

    private static byte[] readBytes(String object) {
        return object.getBytes(StandardCharsets.UTF_8);
    }
}

