/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.rest;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.rest.security.AlexandriaSecurityManager;
import io.intino.alexandria.rest.security.NullSecurityManager;
import io.intino.alexandria.rest.spark.PushService;
import io.intino.alexandria.rest.spark.SparkManager;
import io.intino.alexandria.rest.spark.SparkRouter;
import java.util.function.Consumer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.thread.ThreadPool;
import spark.Service;
import spark.Spark;
import spark.embeddedserver.EmbeddedServers;
import spark.embeddedserver.jetty.EmbeddedJettyServer;
import spark.embeddedserver.jetty.JettyHandler;
import spark.embeddedserver.jetty.JettyServerFactory;
import spark.http.matching.MatcherFilter;
import spark.route.Routes;
import spark.staticfiles.StaticFilesConfiguration;

public class AlexandriaSpark<R extends SparkRouter> {
    private AlexandriaSecurityManager securityManager = new NullSecurityManager();
    protected final String webDirectory;
    protected PushService pushService;
    protected static final String WebDirectory = "/www";
    protected Service service;
    protected int port;

    public AlexandriaSpark(int port) {
        this(port, WebDirectory);
    }

    public AlexandriaSpark(int port, String webDirectory) {
        this.port = port;
        this.webDirectory = webDirectory;
        this.service = Service.ignite();
        this.setup();
        this.service.port(this.port);
    }

    public AlexandriaSpark start() {
        this.service.init();
        return this;
    }

    public void stop() {
        if (this.service != null) {
            this.service.stop();
        }
        this.service = null;
    }

    public String webDirectory() {
        return this.webDirectory;
    }

    public void secure(AlexandriaSecurityManager manager) {
        this.securityManager = manager;
    }

    public R route(String path) {
        R router = this.createRouter(path);
        ((SparkRouter)router).inject(this.pushService);
        ((SparkRouter)router).whenRegisterPushService(this.pushServiceConsumer());
        ((SparkRouter)router).whenValidate(manager -> this.securityManager.check(manager.fromQuery("hash", String.class), manager.fromQuery("signature", String.class)));
        return router;
    }

    private Consumer<PushService> pushServiceConsumer() {
        return pushService -> {
            this.pushService = pushService;
        };
    }

    protected R createRouter(String path) {
        return (R)new SparkRouter(this.service, path);
    }

    protected void setupStaticFiles() {
        if (this.isInClasspath(this.webDirectory)) {
            this.service.staticFileLocation(this.webDirectory);
        } else {
            this.service.externalStaticFileLocation(this.webDirectory);
        }
    }

    private boolean isInClasspath(String path) {
        return this.getClass().getClassLoader().getResourceAsStream(path) != null;
    }

    private void setup() {
        this.setupRequest();
        this.setupStaticFiles();
    }

    private void setupRequest() {
        EmbeddedServers.add((Object)EmbeddedServers.Identifiers.JETTY, (routeMatcher, staticFilesConfiguration, hasMultipleHandler) -> {
            JettyHandler handler = AlexandriaSpark.setupRequestHandler(routeMatcher, staticFilesConfiguration, hasMultipleHandler);
            return new EmbeddedJettyServer(new JettyServerFactory(){

                @Override
                public Server create(int i, int i1, int i2) {
                    return this.server();
                }

                @Override
                public Server create(ThreadPool threadPool) {
                    return this.server();
                }

                private Server server() {
                    Server result = new Server();
                    result.setAttribute("org.eclipse.jetty.server.Request.maxFormContentSize", 0x6400000);
                    return result;
                }
            }, handler);
        });
    }

    private static JettyHandler setupRequestHandler(Routes routeMatcher, StaticFilesConfiguration staticFilesConfiguration, boolean hasMultipleHandler) {
        MatcherFilter matcherFilter = new MatcherFilter(routeMatcher, staticFilesConfiguration, false, hasMultipleHandler);
        matcherFilter.init(null);
        return new JettyHandler(matcherFilter);
    }

    static {
        Spark.initExceptionHandler(Logger::error);
    }

    public static interface ResourceCaller<SM extends SparkManager> {
        public void call(SM var1) throws AlexandriaException;
    }
}

