/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.message;

import io.intino.alexandria.message.DataValue;
import io.intino.alexandria.message.NullValue;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Message {
    static final String AttachmentHeader = "[&]";
    private static Value NullValue = new NullValue();
    private String type;
    private Message owner;
    private Map<String, Attribute> attributes;
    private List<Message> components;
    private Map<String, byte[]> attachments;

    public Message(String type) {
        this.type = type;
        this.owner = null;
        this.attributes = new LinkedHashMap<String, Attribute>();
        this.attachments = new HashMap<String, byte[]>();
        this.components = null;
    }

    public String type() {
        return this.type;
    }

    public boolean is(String type) {
        return type.equalsIgnoreCase(this.type);
    }

    public void type(String type) {
        this.type = type;
    }

    public List<String> attributes() {
        return new ArrayList<String>(this.attributes.keySet());
    }

    public Value get(String attribute) {
        return this.contains(attribute) ? new DataValue(this.use((String)attribute).value, this.attachments) : NullValue;
    }

    public Message set(String attribute, Boolean value) {
        return this.set(attribute, value.toString());
    }

    public Message set(String attribute, Instant value) {
        return this.set(attribute, value.toString());
    }

    public Message set(String attribute, Long value) {
        return this.set(attribute, value.toString());
    }

    public Message set(String attribute, Integer value) {
        return this.set(attribute, value.toString());
    }

    public Message set(String attribute, Double value) {
        return this.set(attribute, value.toString());
    }

    public Message set(String attribute, String value, InputStream is) {
        return this.set(attribute, value, Message.contentOf(is));
    }

    public Message set(String attribute, String value, byte[] content) {
        return this.set(attribute, value + "@" + this.attach(content));
    }

    public Message set(String attribute, String value) {
        this.remove(attribute);
        this.use((String)attribute).value = value;
        return this;
    }

    public Message append(String attribute, Boolean value) {
        return this.append(this.use(attribute), value.toString());
    }

    public Message append(String attribute, Instant value) {
        return this.append(this.use(attribute), value.toString());
    }

    public Message append(String attribute, Long value) {
        return this.append(this.use(attribute), value.toString());
    }

    public Message append(String attribute, Integer value) {
        return this.append(this.use(attribute), value.toString());
    }

    public Message append(String attribute, Double value) {
        return this.append(this.use(attribute), value.toString());
    }

    public Message append(String attribute, String value) {
        return this.append(this.use(attribute), value);
    }

    public Message append(String attribute, String name, InputStream is) {
        return this.append(attribute, name, Message.contentOf(is));
    }

    public Message append(String attribute, String name, byte[] content) {
        return this.append(attribute, name + "@" + this.attach(content));
    }

    private Message append(Attribute attribute, String value) {
        attribute.value = (attribute.value == null ? "" : attribute.value + "\n") + (value == null ? "\u0000" : value);
        return this;
    }

    public Message rename(String attribute, String newName) {
        this.use((String)attribute).name = newName;
        this.add(this.use(attribute));
        this.remove(attribute);
        return this;
    }

    public Message remove(String attribute) {
        this.detach(this.use((String)attribute).value);
        this.attributes.remove(attribute.toLowerCase());
        return this;
    }

    public Message remove(String attribute, Object value) {
        this.detach(this.use((String)attribute).value);
        Attribute attr = this.attributes.get(attribute.toLowerCase());
        if (attr == null) {
            return this;
        }
        attr.value = attr.value.replace(value.toString() + "\n", "");
        if (attr.value.isEmpty()) {
            this.remove(attribute);
        }
        return this;
    }

    private Attribute use(String attribute) {
        if (!this.contains(attribute)) {
            this.add(new Attribute(attribute));
        }
        return this.attributes.get(attribute.toLowerCase());
    }

    private void add(Attribute attribute) {
        this.attributes.put(attribute.name.toLowerCase(), attribute);
    }

    private String attach(byte[] content) {
        String uuid = UUID.random();
        this.attachments.put(uuid, content);
        return uuid;
    }

    private void detach(String value) {
        if (value == null || !value.contains("@")) {
            return;
        }
        this.removeAttachments(value);
    }

    private void removeAttachments(String value) {
        for (String item : value.split("\n")) {
            this.removeAttachment(this.uuidIn(item));
        }
    }

    private String uuidIn(String item) {
        return item.substring(item.indexOf(64) + 1);
    }

    private void removeAttachment(String uuid) {
        if (UUID.is(uuid)) {
            this.attachments.remove(uuid);
        }
    }

    public List<Message> components() {
        return this.components == null ? new ArrayList<Message>() : new ArrayList<Message>(this.components);
    }

    public List<Message> components(String type) {
        ArrayList<Message> result = new ArrayList<Message>();
        if (this.components == null) {
            return result;
        }
        for (Message component : this.components) {
            if (!component.is(type)) continue;
            result.add(component);
        }
        return result;
    }

    public void add(Message component) {
        if (this.components == null) {
            this.components = new ArrayList<Message>();
        }
        this.components.add(component);
        component.owner = this;
        component.attachments = this.attachments;
    }

    public void add(List<Message> components) {
        if (components == null) {
            return;
        }
        for (Message component : components) {
            this.add(component);
        }
    }

    public void remove(Message component) {
        this.components.remove(component);
    }

    public void remove(List<Message> components) {
        this.components.removeAll(components);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(this.qualifiedType()).append("]\n");
        for (Attribute attribute : this.attributes.values()) {
            sb.append(this.stringOf(attribute)).append("\n");
        }
        for (Message component : this.components()) {
            sb.append("\n").append(component.toString());
        }
        if (this.hasAttachments()) {
            sb.append("\n[&]\n");
        }
        return sb.toString();
    }

    boolean hasAttachments() {
        return this.owner == null && this.attachments.size() > 0;
    }

    Map<String, byte[]> allAttachments() {
        return this.attachments;
    }

    private String stringOf(Attribute attribute) {
        return attribute.name + ":" + (this.isMultiline(attribute.value) ? Message.indent(attribute.value) : " " + attribute.value);
    }

    private boolean isMultiline(String value) {
        return value != null && value.contains("\n");
    }

    private String qualifiedType() {
        return this.owner != null ? this.owner.qualifiedType() + "." + this.type : this.type;
    }

    public int length() {
        return this.toString().length();
    }

    public boolean contains(String attribute) {
        return this.attributes.containsKey(attribute.toLowerCase());
    }

    public List<String> attachments() {
        return new ArrayList<String>(this.attachments.keySet());
    }

    public byte[] attachment(String id) {
        return this.attachments.getOrDefault(id, new byte[0]);
    }

    Message put(Map<String, byte[]> attachments) {
        this.attachments = attachments;
        return this;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Message message = (Message)object;
        return Objects.equals(this.type, message.type) && this.attributes.keySet().stream().allMatch(k -> this.attributeEquals(message, (String)k)) && this.attachments.keySet().stream().allMatch(k -> this.attachmentEquals(message, (String)k)) && Objects.equals(this.components, message.components);
    }

    private boolean attributeEquals(Message message, String key) {
        return message.contains(key) && message.get(key).data().equals(this.get(key).data());
    }

    private boolean attachmentEquals(Message message, String key) {
        return Arrays.equals(message.attachments.get(key), message.attachments.get(key));
    }

    public int hashCode() {
        return Objects.hash(this.type, this.owner, this.attributes, this.components, this.attachments);
    }

    private static String indent(String text) {
        return "\n\t" + text.replaceAll("\\n", "\n\t");
    }

    private static byte[] contentOf(InputStream is) {
        byte[] byArray;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            int length;
            byte[] data = new byte[16384];
            while ((length = is.read(data, 0, data.length)) != -1) {
                os.write(data, 0, length);
            }
            os.flush();
            byArray = os.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    os.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return new byte[0];
            }
        }
        os.close();
        return byArray;
    }

    private static class UUID {
        private static int[] HyphenPositions = new int[]{8, 13, 18, 23};

        private UUID() {
        }

        static boolean is(String str) {
            for (int n : HyphenPositions) {
                if (str.charAt(n) == '-') continue;
                return false;
            }
            return true;
        }

        static String random() {
            return java.util.UUID.randomUUID().toString();
        }
    }

    static class Attribute {
        String name;
        String value;

        Attribute(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name + ":" + this.value;
        }
    }

    public static interface Value {
        public String data();

        public <T> T as(Class<T> var1);

        public Instant asInstant();

        public int asInteger();

        public Long asLong();

        public String asString();

        public double asDouble();

        public boolean asBoolean();
    }
}

