/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.message;

import io.intino.alexandria.Resource;
import io.intino.alexandria.message.Formatter;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;

class FormatterFactory {
    private static final String NullValue = "\u0000";
    private static final Map<Class, Formatter> formatters = new HashMap<Class, Formatter>();

    FormatterFactory() {
    }

    public static Formatter get(Class<?> aClass) {
        return formatters.get(aClass);
    }

    public static void put(Class<?> aClass, Formatter formatter) {
        formatters.put(aClass, formatter);
    }

    private static String formatText(Object o) {
        if (o == null) {
            return NullValue;
        }
        String text = o.toString();
        return text.contains("\n") ? "\n\t" + text.replaceAll("\n", "\n\t") : text;
    }

    private static String formatResource(Object o) {
        if (o == null) {
            return NullValue;
        }
        return "@" + o.toString();
    }

    static {
        formatters.put(String.class, FormatterFactory::formatText);
        formatters.put(Boolean.class, Object::toString);
        formatters.put(Byte.class, Object::toString);
        formatters.put(Integer.class, Object::toString);
        formatters.put(Float.class, Object::toString);
        formatters.put(Double.class, Object::toString);
        formatters.put(Instant.class, Object::toString);
        formatters.put(Resource.class, FormatterFactory::formatResource);
        formatters.put(String[].class, ArrayFormatter.of(String.class)::format);
        formatters.put(Boolean[].class, ArrayFormatter.of(Boolean.class)::format);
        formatters.put(Byte[].class, ArrayFormatter.of(Byte.class)::format);
        formatters.put(Integer[].class, ArrayFormatter.of(Integer.class)::format);
        formatters.put(Float[].class, ArrayFormatter.of(Float.class)::format);
        formatters.put(Double[].class, ArrayFormatter.of(Double.class)::format);
        formatters.put(Instant[].class, ArrayFormatter.of(Instant.class)::format);
        formatters.put(Resource[].class, ArrayFormatter.of(Resource.class)::format);
    }

    static class ArrayFormatter {
        private Formatter formatter;

        ArrayFormatter(Formatter formatter) {
            this.formatter = formatter;
        }

        static ArrayFormatter of(Class type) {
            return new ArrayFormatter((Formatter)formatters.get(type));
        }

        String format(Object o) {
            StringBuilder result = new StringBuilder();
            for (Object item : (Object[])o) {
                result.append("\n\t").append(item == null ? FormatterFactory.NullValue : this.formatter.format(item));
            }
            return result.toString();
        }
    }
}

