/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.message;

import io.intino.alexandria.Resource;
import io.intino.alexandria.message.Message;
import io.intino.alexandria.message.Parser;
import java.time.Instant;
import java.util.Arrays;
import java.util.Map;

class DataValue
implements Message.Value {
    private final String data;
    private final Map<String, byte[]> attachments;

    public DataValue(String data, Map<String, byte[]> attachments) {
        this.data = data;
        this.attachments = attachments;
    }

    @Override
    public String data() {
        return this.data;
    }

    @Override
    public <T> T as(Class<T> type) {
        if (this.data != null) {
            return (T)this.fill(Parser.of(type).parse(this.data));
        }
        if (type.isArray()) {
            return (T)new Object[0];
        }
        return null;
    }

    @Override
    public Instant asInstant() {
        return Instant.parse(this.data);
    }

    @Override
    public int asInteger() {
        return Integer.parseInt(this.data);
    }

    @Override
    public Long asLong() {
        return Long.parseLong(this.data);
    }

    @Override
    public String asString() {
        return this.data;
    }

    @Override
    public double asDouble() {
        return Double.parseDouble(this.data);
    }

    @Override
    public boolean asBoolean() {
        return Boolean.parseBoolean(this.data);
    }

    private Object fill(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Resource) {
            return this.fill((Resource)object);
        }
        if (object instanceof Resource[]) {
            return this.fill((Resource[])object);
        }
        return object;
    }

    private Resource[] fill(Resource[] resources) {
        return (Resource[])Arrays.stream(resources).map(this::fill).toArray(Resource[]::new);
    }

    private Resource fill(Resource resource) {
        String key = new String(resource.bytes());
        return new Resource(resource.name(), this.attachments.getOrDefault(key, new byte[0]));
    }

    public String toString() {
        return this.data;
    }
}

