/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.event;

import io.intino.alexandria.event.Event;
import io.intino.alexandria.event.EventHub;
import io.intino.alexandria.event.EventOutBox;
import io.intino.alexandria.jms.BusConnector;
import io.intino.alexandria.jms.ConnectionListener;
import io.intino.alexandria.jms.JmsConsumer;
import io.intino.alexandria.jms.JmsProducer;
import io.intino.alexandria.jms.MessageReader;
import io.intino.alexandria.jms.MessageWriter;
import io.intino.alexandria.jms.QueueConsumer;
import io.intino.alexandria.jms.QueueProducer;
import io.intino.alexandria.jms.TopicConsumer;
import io.intino.alexandria.jms.TopicProducer;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.message.Message;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQSession;

public class JmsEventHub
implements EventHub {
    private final Map<String, JmsProducer> producers;
    private final Map<String, JmsConsumer> consumers;
    private final Map<String, List<Consumer<Event>>> eventConsumers;
    private final Map<Consumer<javax.jms.Message>, Integer> jmsConsumers;
    private final EventOutBox eventOutBox;
    private Connection connection;
    private Session session;
    private AtomicBoolean connected = new AtomicBoolean(false);
    private AtomicBoolean recoveringEvents = new AtomicBoolean(false);
    private ScheduledExecutorService scheduler;

    public JmsEventHub(String brokerUrl, String user, String password, String clientId, File messageCacheDirectory) {
        this(brokerUrl, user, password, clientId, false, messageCacheDirectory);
    }

    public JmsEventHub(String brokerUrl, String user, String password, String clientId, boolean transactedSession, File messageCacheDirectory) {
        this.producers = new HashMap<String, JmsProducer>();
        this.consumers = new HashMap<String, JmsConsumer>();
        this.jmsConsumers = new HashMap<Consumer<javax.jms.Message>, Integer>();
        this.eventConsumers = new HashMap<String, List<Consumer<Event>>>();
        this.eventOutBox = new EventOutBox(messageCacheDirectory);
        if (brokerUrl != null && !brokerUrl.isEmpty()) {
            Thread thread = Thread.currentThread();
            new Thread(() -> {
                this.initConnection(brokerUrl, user, password, clientId);
                thread.interrupt();
            }).start();
            try {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.connection != null && ((ActiveMQConnection)this.connection).isStarted()) {
                    this.session = this.createSession(transactedSession);
                    if (this.session != null && ((ActiveMQSession)this.session).isRunning()) {
                        this.connected.set(true);
                        Logger.info("Connection with Data Hub stablished!");
                    }
                }
            }
            catch (JMSException e) {
                Logger.error(e);
            }
        } else {
            Logger.warn("Broker url is null");
        }
        this.scheduler = Executors.newScheduledThreadPool(1);
        this.scheduler.scheduleAtFixedRate(this::recoverEvents, 0L, 1L, TimeUnit.HOURS);
    }

    private void initConnection(String brokerUrl, String user, String password, String clientId) {
        try {
            this.connection = BusConnector.createConnection(brokerUrl, user, password, this.connectionListener());
            if (clientId != null && !clientId.isEmpty()) {
                this.connection.setClientID(clientId);
            }
            this.connection.start();
        }
        catch (JMSException e) {
            Logger.error(e);
        }
    }

    @Override
    public synchronized void sendEvent(String channel, Event event) {
        new ArrayList<Consumer>(this.eventConsumers.getOrDefault(channel, Collections.emptyList())).forEach(eventConsumer -> eventConsumer.accept(event));
        new Thread(() -> {
            if (this.connected.get() && !this.eventOutBox.isEmpty() && !this.recoveringEvents.get()) {
                this.recoverEvents();
            }
            if (!this.doSendEvent(channel, event)) {
                this.eventOutBox.push(channel, event);
            }
        }).start();
    }

    @Override
    public void requestResponse(String channel, String event, Consumer<String> onResponse) {
        if (this.session == null) {
            Logger.error("Session is null");
            return;
        }
        try {
            QueueProducer producer = new QueueProducer(this.session, channel);
            TemporaryQueue temporaryQueue = this.session.createTemporaryQueue();
            MessageConsumer consumer = this.session.createConsumer(temporaryQueue);
            consumer.setMessageListener(m -> this.acceptMessage(onResponse, consumer, (TextMessage)m));
            TextMessage txtMessage = this.session.createTextMessage();
            txtMessage.setText(event);
            txtMessage.setJMSReplyTo(temporaryQueue);
            txtMessage.setJMSCorrelationID(JmsEventHub.createRandomString());
            producer.produce(txtMessage);
            producer.close();
        }
        catch (JMSException e) {
            Logger.error(e);
        }
    }

    @Override
    public void attachListener(String channel, Consumer<Event> onEventReceived) {
        this.registerConsumer(channel, onEventReceived);
        JmsConsumer consumer = this.consumers.get(channel);
        if (consumer == null) {
            return;
        }
        Consumer<javax.jms.Message> eventConsumer = e -> onEventReceived.accept(new Event(MessageDeserializer.deserialize(e)));
        this.jmsConsumers.put(eventConsumer, eventConsumer.hashCode());
        consumer.listen(eventConsumer);
    }

    @Override
    public void attachListener(String channel, String subscriberId, Consumer<Event> onEventReceived) {
        this.registerConsumer(channel, onEventReceived);
        TopicConsumer consumer = (TopicConsumer)this.consumers.get(channel);
        if (consumer == null) {
            return;
        }
        Consumer<javax.jms.Message> eventConsumer = m -> onEventReceived.accept(new Event(MessageDeserializer.deserialize(m)));
        this.jmsConsumers.put(eventConsumer, eventConsumer.hashCode());
        consumer.listen(eventConsumer, subscriberId);
    }

    @Override
    public void detachListeners(String channel) {
        if (this.consumers.containsKey(channel)) {
            this.consumers.get(channel).close();
            this.consumers.remove(channel);
            this.eventConsumers.get(channel).clear();
        }
    }

    @Override
    public void detachListeners(Consumer<Event> consumer) {
        Integer code = this.jmsConsumers.get(consumer);
        if (code == null) {
            return;
        }
        this.eventConsumers.values().forEach(list -> list.remove(consumer));
        for (JmsConsumer jc : this.consumers.values()) {
            List<Consumer> toRemove = jc.listeners().stream().filter(l -> l.hashCode() == code.intValue()).collect(Collectors.toList());
            toRemove.forEach(jc::removeListener);
        }
    }

    @Override
    public void attachRequestListener(String channel, EventHub.RequestConsumer onRequestReceived) {
        JmsConsumer consumer;
        if (this.session == null) {
            return;
        }
        if (!this.consumers.containsKey(channel)) {
            this.consumers.put(channel, this.queueConsumer(channel));
        }
        if ((consumer = this.consumers.get(channel)) == null) {
            return;
        }
        if (!(consumer instanceof QueueConsumer)) {
            Logger.error("Already exists a topic and queue with this path " + channel);
            return;
        }
        consumer.listen(event -> new Thread(() -> {
            try {
                String result = onRequestReceived.accept(MessageReader.textFrom(event));
                if (result == null) {
                    return;
                }
                TextMessage response = this.session.createTextMessage();
                response.setText(result);
                response.setJMSCorrelationID(event.getJMSCorrelationID());
                QueueProducer producer = new QueueProducer(this.session, event.getJMSReplyTo());
                producer.produce(response);
                producer.close();
            }
            catch (JMSException e) {
                Logger.error(e);
            }
        }).start());
    }

    public Connection connection() {
        return this.connection;
    }

    public Session session() {
        return this.session;
    }

    public void stop() {
        this.consumers.values().forEach(JmsConsumer::close);
        this.consumers.clear();
        this.producers.values().forEach(JmsProducer::close);
        try {
            this.session.close();
            this.connection.close();
        }
        catch (JMSException e) {
            Logger.error(e);
        }
    }

    private Session createSession(boolean transactedSession) throws JMSException {
        return this.connection.createSession(transactedSession, transactedSession ? 0 : 1);
    }

    private void registerConsumer(String channel, Consumer<Event> onEventReceived) {
        this.eventConsumers.putIfAbsent(channel, new CopyOnWriteArrayList());
        this.eventConsumers.get(channel).add(onEventReceived);
        if (!this.consumers.containsKey(channel) && this.session != null) {
            this.consumers.put(channel, this.topicConsumer(channel));
        }
    }

    private boolean doSendEvent(String channel, Event event) {
        if (this.session == null || !this.connected.get()) {
            return false;
        }
        try {
            JmsProducer producer;
            if (!this.producers.containsKey(channel)) {
                this.producers.put(channel, new TopicProducer(this.session, channel));
            }
            if ((producer = this.producers.get(channel)) == null) {
                return false;
            }
            return producer.produce(JmsEventHub.serialize(event));
        }
        catch (IOException | JMSException e) {
            Logger.error(e);
            return false;
        }
    }

    private void acceptMessage(Consumer<String> onResponse, MessageConsumer consumer, TextMessage m) {
        try {
            onResponse.accept(m.getText());
            consumer.close();
        }
        catch (JMSException e) {
            Logger.error(e);
        }
    }

    private ConnectionListener connectionListener() {
        return new ConnectionListener(){

            @Override
            public void transportInterupted() {
                JmsEventHub.this.connected.set(false);
            }

            @Override
            public void transportResumed() {
                Logger.info("Connection with Data Hub resumed!");
                JmsEventHub.this.connected.set(true);
                if (!JmsEventHub.this.eventConsumers.isEmpty() && JmsEventHub.this.consumers.isEmpty()) {
                    try {
                        JmsEventHub.this.session = JmsEventHub.this.createSession(false);
                        for (String channel : JmsEventHub.this.eventConsumers.keySet()) {
                            JmsEventHub.this.consumers.put(channel, JmsEventHub.this.topicConsumer(channel));
                        }
                    }
                    catch (JMSException e) {
                        Logger.error(e);
                    }
                }
            }
        };
    }

    private TopicConsumer topicConsumer(String channel) {
        try {
            return new TopicConsumer(this.session, channel);
        }
        catch (JMSException e) {
            Logger.error(e);
            return null;
        }
    }

    private QueueConsumer queueConsumer(String channel) {
        try {
            return new QueueConsumer(this.session, channel);
        }
        catch (JMSException e) {
            Logger.error(e);
            return null;
        }
    }

    private void recoverEvents() {
        this.recoveringEvents.set(true);
        if (!this.eventOutBox.isEmpty()) {
            while (!this.eventOutBox.isEmpty()) {
                Map.Entry<String, Event> event = this.eventOutBox.get();
                if (event == null) continue;
                if (!this.doSendEvent(event.getKey(), event.getValue())) break;
                this.eventOutBox.pop();
            }
        }
        this.recoveringEvents.set(false);
    }

    private static String createRandomString() {
        Random random = new Random(System.currentTimeMillis());
        long randomLong = random.nextLong();
        return Long.toHexString(randomLong);
    }

    private static javax.jms.Message serialize(Event event) throws IOException, JMSException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        io.intino.alexandria.message.MessageWriter messageWriter = new io.intino.alexandria.message.MessageWriter(os);
        messageWriter.write(event.toMessage());
        messageWriter.close();
        return MessageWriter.write(os.toString());
    }

    private static class MessageDeserializer {
        private MessageDeserializer() {
        }

        static Message deserialize(javax.jms.Message message) {
            return new io.intino.alexandria.message.MessageReader(MessageReader.textFrom(message)).next();
        }
    }
}

