/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.elasticmapreduce.model.InstanceGroupModifyConfig;
import com.amazonaws.services.elasticmapreduce.model.ModifyInstanceGroupsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyInstanceGroupsRequestMarshaller
implements Marshaller<Request<ModifyInstanceGroupsRequest>, ModifyInstanceGroupsRequest> {
    @Override
    public Request<ModifyInstanceGroupsRequest> marshall(ModifyInstanceGroupsRequest modifyInstanceGroupsRequest) {
        if (modifyInstanceGroupsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ModifyInstanceGroupsRequest> request = new DefaultRequest<ModifyInstanceGroupsRequest>(modifyInstanceGroupsRequest, "AmazonElasticMapReduce");
        request.addParameter("Action", "ModifyInstanceGroups");
        request.addParameter("Version", "2009-03-31");
        List<InstanceGroupModifyConfig> instanceGroupsList = modifyInstanceGroupsRequest.getInstanceGroups();
        int instanceGroupsListIndex = 1;
        for (InstanceGroupModifyConfig instanceGroupsListValue : instanceGroupsList) {
            InstanceGroupModifyConfig instanceGroupModifyConfigMember = instanceGroupsListValue;
            if (instanceGroupModifyConfigMember != null) {
                if (instanceGroupModifyConfigMember.getInstanceGroupId() != null) {
                    request.addParameter("InstanceGroups.member." + instanceGroupsListIndex + ".InstanceGroupId", StringUtils.fromString(instanceGroupModifyConfigMember.getInstanceGroupId()));
                }
                if (instanceGroupModifyConfigMember.getInstanceCount() != null) {
                    request.addParameter("InstanceGroups.member." + instanceGroupsListIndex + ".InstanceCount", StringUtils.fromInteger(instanceGroupModifyConfigMember.getInstanceCount()));
                }
            }
            ++instanceGroupsListIndex;
        }
        return request;
    }
}

