/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.containers;

import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.sonatype.guice.bean.binders.ParameterKeys;
import org.sonatype.guice.bean.binders.SpaceModule;
import org.sonatype.guice.bean.binders.WireModule;
import org.sonatype.guice.bean.containers.Main;
import org.sonatype.guice.bean.containers.SisuGuice;
import org.sonatype.guice.bean.locators.DefaultBeanLocator;
import org.sonatype.guice.bean.locators.MutableBeanLocator;
import org.sonatype.guice.bean.reflect.BundleClassSpace;
import org.sonatype.guice.bean.reflect.Logs;
import org.sonatype.inject.BeanScanning;

public final class SisuActivator
implements BundleActivator,
BundleTrackerCustomizer,
ServiceTrackerCustomizer {
    static final String CONTAINER_SYMBOLIC_NAME = "org.sonatype.inject";
    static final String BUNDLE_INJECTOR_CLASS_NAME = BundleInjector.class.getName();
    static final MutableBeanLocator locator = new DefaultBeanLocator();
    private BundleContext bundleContext;
    private ServiceTracker serviceTracker;
    private BundleTracker bundleTracker;

    public void start(BundleContext context) {
        this.bundleContext = context;
        this.serviceTracker = new ServiceTracker(context, BUNDLE_INJECTOR_CLASS_NAME, (ServiceTrackerCustomizer)this);
        this.serviceTracker.open();
        this.bundleTracker = new BundleTracker(context, 40, (BundleTrackerCustomizer)this);
        this.bundleTracker.open();
    }

    public void stop(BundleContext context) {
        this.bundleTracker.close();
        this.serviceTracker.close();
        locator.clear();
    }

    public Object addingBundle(Bundle bundle2, BundleEvent event) {
        if (CONTAINER_SYMBOLIC_NAME.equals(bundle2.getSymbolicName())) {
            return null;
        }
        if (SisuActivator.needsScanning(bundle2) && SisuActivator.getBundleInjectorService(bundle2) == null) {
            try {
                new BundleInjector(bundle2);
            }
            catch (RuntimeException e) {
                Logs.warn("Problem starting: {}", bundle2, e);
            }
        }
        return null;
    }

    public void modifiedBundle(Bundle bundle2, BundleEvent event, Object object) {
    }

    public void removedBundle(Bundle bundle2, BundleEvent event, Object object) {
    }

    public Object addingService(ServiceReference reference) {
        Object service = this.bundleContext.getService(reference);
        locator.add(((BundleInjector)service).getInjector(), 0);
        return service;
    }

    public void modifiedService(ServiceReference reference, Object service) {
    }

    public void removedService(ServiceReference reference, Object service) {
        locator.remove(((BundleInjector)service).getInjector());
    }

    private static boolean needsScanning(Bundle bundle2) {
        Dictionary headers = bundle2.getHeaders();
        String host = (String)headers.get("Fragment-Host");
        if (null != host) {
            return false;
        }
        String imports = (String)headers.get("Import-Package");
        if (null == imports) {
            return false;
        }
        return imports.contains("javax.inject") || imports.contains("com.google.inject");
    }

    private static ServiceReference getBundleInjectorService(Bundle bundle2) {
        ServiceReference[] serviceReferences = bundle2.getRegisteredServices();
        if (null != serviceReferences) {
            for (ServiceReference ref : serviceReferences) {
                for (String name : (String[])ref.getProperty("objectClass")) {
                    if (!BUNDLE_INJECTOR_CLASS_NAME.equals(name)) continue;
                    return ref;
                }
            }
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class BundleProperties
    extends AbstractMap<Object, Object> {
        private final transient BundleContext context;

        BundleProperties(BundleContext context) {
            this.context = context;
        }

        @Override
        public Object get(Object key) {
            return this.context.getProperty(String.valueOf(key));
        }

        @Override
        public boolean containsKey(Object key) {
            return null != this.get(key);
        }

        @Override
        public Set<Map.Entry<Object, Object>> entrySet() {
            return Collections.emptySet();
        }

        @Override
        public int size() {
            return 0;
        }
    }

    private static final class BundleInjector
    implements Module {
        private static final String[] API = new String[]{BUNDLE_INJECTOR_CLASS_NAME};
        private final Map<?, ?> properties;
        private final Injector injector;
        private final BundleContext extendedBundleContext;

        BundleInjector(Bundle bundle2) {
            this.extendedBundleContext = bundle2.getBundleContext();
            this.properties = new BundleProperties(this.extendedBundleContext);
            BundleClassSpace space = new BundleClassSpace(bundle2);
            BeanScanning scanning = Main.selectScanning(this.properties);
            this.injector = Guice.createInjector(new WireModule(this, new SpaceModule(space, scanning)));
            Hashtable<String, String> metadata = new Hashtable<String, String>();
            ((Dictionary)metadata).put("service.pid", SisuActivator.CONTAINER_SYMBOLIC_NAME);
            this.extendedBundleContext.registerService(API, (Object)this, metadata);
        }

        public void configure(Binder binder) {
            binder.requestStaticInjection(SisuGuice.class);
            binder.bind(ParameterKeys.PROPERTIES).toInstance(this.properties);
            binder.bind(MutableBeanLocator.class).toInstance(locator);
            binder.bind(BundleContext.class).toInstance(this.extendedBundleContext);
        }

        public Injector getInjector() {
            return this.injector;
        }
    }
}

