/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.magritte.stores;

import io.intino.tara.io.Stash;
import io.intino.tara.io.StashDeserializer;
import io.intino.tara.io.StashSerializer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.Store;
import io.intino.tara.magritte.stores.ResourcesStore;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.logging.Logger;

public class FileSystemStore
implements Store {
    protected final File file;
    protected boolean allowWriting = true;

    public FileSystemStore(File file) {
        this.file = file;
        file.mkdirs();
    }

    public File directory() {
        return this.file;
    }

    @Override
    public boolean allowWriting() {
        return this.allowWriting;
    }

    public FileSystemStore allowWriting(boolean allowWriting) {
        this.allowWriting = allowWriting;
        return this;
    }

    @Override
    public Stash stashFrom(String path) {
        if (this.fileOf(path).exists()) {
            return StashDeserializer.stashFrom(this.fileOf(path));
        }
        return new ResourcesStore().stashFrom(path);
    }

    @Override
    public URL resourceFrom(String path) {
        try {
            return this.fileOf(path).exists() ? this.fileOf(path).toURI().toURL() : new ResourcesStore().resourceFrom(path);
        }
        catch (MalformedURLException e) {
            Logger.getGlobal().severe(e.getCause().getMessage());
            return null;
        }
    }

    @Override
    public URL writeResource(InputStream inputStream, String newPath, URL oldUrl, Node node) {
        try {
            if (inputStream == null) {
                return this.preparePath(newPath).toURI().toURL();
            }
            Files.write(this.preparePath(newPath).toPath(), this.bytesOf(inputStream), new OpenOption[0]);
            return this.resourceFrom(newPath);
        }
        catch (IOException e) {
            Logger.getGlobal().severe("Resource at " + newPath + "could not be stored. Cause: " + e.getCause().getMessage());
            return null;
        }
    }

    @Override
    public String relativePathOf(URL url) {
        try {
            if (!url.getProtocol().contains("file")) {
                return new ResourcesStore().relativePathOf(url);
            }
            String absolutePath = new File(url.toURI()).getAbsolutePath();
            if (!absolutePath.startsWith(this.file.getAbsolutePath())) {
                return new ResourcesStore().relativePathOf(url);
            }
            return absolutePath.equals(this.file.getAbsolutePath()) ? "" : absolutePath.substring(this.file.getAbsolutePath().length() + 1);
        }
        catch (URISyntaxException ignored) {
            return null;
        }
    }

    @Override
    public void writeStash(Stash stash, String path) {
        try {
            Stash composedStash = this.composeStash(path, stash);
            if (this.hasContent(composedStash)) {
                Files.write(this.preparePath(path).toPath(), StashSerializer.serialize(composedStash), new OpenOption[0]);
            } else {
                this.preparePath(path).delete();
            }
        }
        catch (IOException e) {
            Logger.getGlobal().severe("File at " + path + " couldn't be written");
        }
    }

    private boolean hasContent(Stash composedStash) {
        return !composedStash.nodes.isEmpty() || !composedStash.concepts.isEmpty();
    }

    private Stash previousStash(String path) {
        return this.fileOf(path).exists() ? this.stashFrom(path) : new ResourcesStore().stashFrom(path);
    }

    private File preparePath(String path) {
        File file = this.fileOf(path);
        file.getParentFile().mkdirs();
        return file;
    }

    protected File fileOf(String path) {
        return new File(this.file, path);
    }
}

