/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.magritte.stores;

import io.intino.tara.io.Stash;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.stores.FileSystemStore;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class AdvancedFileSystemStore
extends FileSystemStore {
    private static final String SEP = ";";
    private Map<String, List<ResourceModification>> resources = new HashMap<String, List<ResourceModification>>();

    public AdvancedFileSystemStore(File file) {
        super(file);
        if (this.commitFile().exists()) {
            this.loadCommit();
        }
        this.processCommit();
    }

    private void processCommit() {
        List<ResourceModification> list = this.resources.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        list.forEach(r -> this.remove(r.newUrl));
        if (!list.isEmpty()) {
            Logger.getGlobal().warning(list.size() + " resources have been removed since owners were not saved before");
        }
        this.resources.clear();
        this.commitFile().delete();
    }

    @Override
    public void writeStash(Stash stash, String path) {
        super.writeStash(stash, path);
        this.processModification(stash.nodes);
    }

    @Override
    public URL writeResource(InputStream inputStream, String newPath, URL oldUrl, Node node) {
        URL newUrl = super.writeResource(inputStream, this.buildNewPath(newPath), oldUrl, node);
        this.registerModification(node.id(), newUrl, oldUrl);
        this.writeCommit();
        return newUrl;
    }

    private String buildNewPath(String newPath) {
        return newPath + "_" + UUID.randomUUID();
    }

    private void registerModification(String nodeId, URL newUrl, URL oldUrl) {
        if (!this.resources.containsKey(nodeId)) {
            this.resources.put(nodeId, new ArrayList());
        }
        this.resources.get(nodeId).add(new ResourceModification(newUrl, oldUrl));
    }

    private void processModification(List<io.intino.tara.io.Node> nodes) {
        nodes.forEach(this::processModification);
    }

    private void processModification(io.intino.tara.io.Node node) {
        if (this.resources.containsKey(node.name)) {
            this.removeOldPathIn(node.name);
        }
        this.processModification(node.nodes);
    }

    private void removeOldPathIn(String name) {
        this.resources.get(name).forEach(r -> this.remove(r.oldUrl));
        this.resources.remove(name);
        this.writeCommit();
    }

    private void remove(URL oldUrl) {
        try {
            if (oldUrl == null || !oldUrl.getProtocol().contains("file")) {
                return;
            }
            File oldFile = new File(oldUrl.toURI());
            if (!oldFile.getAbsolutePath().startsWith(this.file.getAbsolutePath())) {
                return;
            }
            if (!oldFile.delete()) {
                Logger.getGlobal().severe("Url " + oldUrl.toString() + " could not be deleted");
            }
        }
        catch (URISyntaxException e) {
            Logger.getGlobal().severe(e.getCause().getMessage());
        }
    }

    private void writeCommit() {
        StringBuilder content = new StringBuilder();
        this.resources.entrySet().forEach(e -> ((List)e.getValue()).forEach(r -> content.append((String)e.getKey()).append(SEP).append(r.newUrl).append(SEP).append(r.oldUrl).append("\n")));
        try {
            Files.write(this.commitFile().toPath(), content.toString().getBytes(), new OpenOption[0]);
        }
        catch (IOException e2) {
            Logger.getGlobal().severe("Commit file could not be written. Reason: " + e2.getCause().getMessage());
        }
    }

    private void loadCommit() {
        try {
            List<String> resources = Files.readAllLines(this.commitFile().toPath());
            resources.stream().filter(s -> !s.isEmpty()).forEach(s -> {
                String[] split = s.split(SEP);
                this.registerModification(split[0], this.urlOf(split[1]), this.urlOf(split[2]));
            });
        }
        catch (IOException e) {
            Logger.getGlobal().log(Level.SEVERE, "Commit file could not be loaded. Reason: " + e.getMessage(), e);
        }
    }

    private URL urlOf(String url) {
        try {
            return !url.equals("null") ? new URL(url) : null;
        }
        catch (MalformedURLException e) {
            Logger.getGlobal().severe("Url is malformed " + url + ". Cause: " + e.getCause().getMessage());
            return null;
        }
    }

    private File commitFile() {
        return this.fileOf(".commit");
    }

    private class ResourceModification {
        URL newUrl;
        URL oldUrl;

        ResourceModification(URL newUrl, URL oldUrl) {
            this.newUrl = newUrl;
            this.oldUrl = oldUrl;
        }
    }
}

