/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.magritte;

import io.intino.tara.magritte.Graph;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Model;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.NodeCloner;
import io.intino.tara.magritte.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class Concept
extends Predicate {
    final Set<Concept> concepts = new LinkedHashSet<Concept>();
    private final Set<Concept> children = new LinkedHashSet<Concept>();
    private final Set<Concept> instances = new LinkedHashSet<Concept>();
    boolean isAbstract;
    boolean isMetaConcept;
    public boolean isAspect;
    boolean isMain;
    Class<? extends Layer> layerClass;
    Concept metatype = null;
    Set<Content> contentRules = new LinkedHashSet<Content>();
    List<Node> nodes = new ArrayList<Node>();
    Map<String, List<?>> variables = new LinkedHashMap();
    Map<String, List<?>> parameters = new LinkedHashMap();
    private Concept parent;

    public Concept(String name) {
        super(name);
    }

    static List<Concept> metaTypesOf(Collection<Concept> metaConcepts) {
        ArrayList<Concept> concepts = new ArrayList<Concept>();
        for (Concept metaConcept : metaConcepts) {
            concepts.addAll(Concept.metaTypesOf(metaConcept.concepts));
            concepts.add(metaConcept);
        }
        return concepts;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean isMetaConcept() {
        return this.isMetaConcept;
    }

    public boolean isMain() {
        return this.isMain;
    }

    public Class<? extends Layer> layerClass() {
        return this.layerClass;
    }

    @Override
    public List<Concept> conceptList() {
        return Collections.unmodifiableList(new ArrayList<Concept>(this.concepts));
    }

    public Concept parent() {
        return this.parent;
    }

    void parent(Concept parent) {
        if (parent == null) {
            return;
        }
        this.parent = parent;
        this.putType(parent);
        parent.children.add(this);
    }

    public List<Concept> children() {
        return Collections.unmodifiableList(new ArrayList<Concept>(this.children));
    }

    void concepts(List<Concept> concepts) {
        concepts.forEach(this::putType);
    }

    public List<Node> nodes() {
        return this.nodes;
    }

    @Override
    protected void putType(Concept concept) {
        if (this.is(concept.id())) {
            return;
        }
        super.putType(concept);
        this.concepts.add(concept);
        concept.instances.add(this);
    }

    public List<Concept> allInstances() {
        LinkedHashSet<Concept> instances = new LinkedHashSet<Concept>();
        instances.addAll(this.instances);
        this.instances.forEach(s -> instances.addAll(s.allInstances()));
        return new ArrayList<Concept>(instances);
    }

    public List<Concept> allChildren() {
        LinkedHashSet<Concept> children = new LinkedHashSet<Concept>();
        children.addAll(this.children);
        this.children.forEach(s -> children.addAll(s.allChildren()));
        return new ArrayList<Concept>(children);
    }

    public List<Concept> multipleAllowed() {
        return Collections.unmodifiableList(this.contentRules.stream().filter(c -> c.max > 1).map(c -> c.concept).collect(Collectors.toList()));
    }

    public List<Concept> singleAllowed() {
        return Collections.unmodifiableList(this.contentRules.stream().filter(c -> c.max == 1).map(c -> c.concept).collect(Collectors.toList()));
    }

    public List<Concept> multipleRequired() {
        return Collections.unmodifiableList(this.contentRules.stream().filter(c -> c.min == 1 && c.max > 1).map(c -> c.concept).collect(Collectors.toList()));
    }

    public List<Concept> singleRequired() {
        return Collections.unmodifiableList(this.contentRules.stream().filter(c -> c.min == 1 && c.max == 1).map(c -> c.concept).collect(Collectors.toList()));
    }

    @Override
    public Map<String, List<?>> variables() {
        return Collections.unmodifiableMap(this.variables);
    }

    @Override
    public <T extends Layer> List<T> findNode(Class<T> aClass) {
        return null;
    }

    public Map<String, List<?>> parameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    @Override
    public List<Node> componentList() {
        return Collections.unmodifiableList(this.nodes);
    }

    Node createRoot(String path, String name, Model model) {
        if (this.isMetaConcept) {
            Logger.getGlobal().severe("Node cannot be created. Concept " + this.id + " is a MetaConcept");
            return null;
        }
        return this.newNode(path + "#" + (name != null ? name : model.graph().createNodeName()), model);
    }

    private boolean ownerContainsComponent(Node owner, String name) {
        return owner.graph().load(owner.id() + "$" + name, false) != null;
    }

    public Node createNode(Node owner) {
        return this.createNode(owner.graph().createNodeName(), owner);
    }

    public Node createNode(String name, Node owner) {
        if (this.isMetaConcept) {
            Logger.getGlobal().severe("Node cannot be created. Concept " + this.id + " is a MetaConcept");
            return null;
        }
        if (owner != null && !(owner instanceof Model) && this.ownerContainsComponent(owner, name)) {
            Logger.getGlobal().severe("Owner " + owner.name() + " contains a component named " + name);
            return null;
        }
        return this.newNode(owner.id() + "$" + (name != null ? name : owner.graph().createNodeName()), owner);
    }

    private Node newNode(String name, Node owner) {
        Node node = owner.graph().node$(name);
        node.owner(owner);
        this.prepareNode(node, owner.graph());
        if (!owner.is("Model")) {
            owner.add(node);
        }
        return node;
    }

    void prepareNode(Node node, Graph graph) {
        List<Concept> metaTypes = Concept.metaTypesOf(Collections.singletonList(this));
        this.addConcepts(node, metaTypes);
        this.cloneNodes(node, graph);
        this.fillVariables(node, metaTypes);
    }

    private void addConcepts(Node node, List<Concept> metaTypes) {
        node.addLayers(metaTypes);
        node.syncLayers();
    }

    private void fillVariables(Node node, List<Concept> types) {
        types.forEach(c -> c.variables.forEach(node::load));
        types.forEach(c -> c.parameters.forEach(node::load));
    }

    private void cloneNodes(Node node, Graph graph) {
        NodeCloner.clone(this.nodesOf(node, graph), node, graph);
    }

    private List<Node> nodesOf(Node node, Graph graph) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (String typeName : node.typeNames) {
            nodes.addAll(graph.concepts.get((Object)typeName).nodes);
        }
        return nodes;
    }

    public String toString() {
        return this.id + "{names=" + this.concepts.stream().map(m -> m.id).collect(Collectors.toList()) + '}';
    }

    public boolean is(String concept) {
        return this.id.equals(concept) || this.typeNames.contains(concept);
    }

    public boolean isAspect() {
        return this.isAspect;
    }

    static class Content {
        Concept concept;
        int min;
        int max;

        Content(Concept concept, int min, int max) {
            this.concept = concept;
            this.min = min;
            this.max = max;
        }
    }
}

