/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.lang.semantics.constraints.parameter;

import io.intino.tara.lang.model.Element;
import io.intino.tara.lang.model.EmptyNode;
import io.intino.tara.lang.model.Node;
import io.intino.tara.lang.model.Parameter;
import io.intino.tara.lang.model.Parametrized;
import io.intino.tara.lang.model.Primitive;
import io.intino.tara.lang.model.Rule;
import io.intino.tara.lang.model.Tag;
import io.intino.tara.lang.model.rules.Size;
import io.intino.tara.lang.model.rules.variable.NativeObjectRule;
import io.intino.tara.lang.model.rules.variable.NativeRule;
import io.intino.tara.lang.model.rules.variable.VariableRule;
import io.intino.tara.lang.semantics.constraints.PrimitiveTypeCompatibility;
import io.intino.tara.lang.semantics.constraints.parameter.ParameterConstraint;
import io.intino.tara.lang.semantics.errorcollector.SemanticException;
import io.intino.tara.lang.semantics.errorcollector.SemanticNotification;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class PrimitiveParameter
extends ParameterConstraint {
    private final String name;
    private final Primitive type;
    private final String aspect;
    private final Size size;
    private final int position;
    private final String scope;
    private final VariableRule rule;
    private final Set<Tag> flags;

    public PrimitiveParameter(String name, Primitive type, String aspect, Size size, int position, String level, VariableRule rule, List<Tag> flags) {
        this.name = name;
        this.type = type;
        this.aspect = aspect;
        this.size = size;
        this.position = position;
        this.scope = level;
        this.rule = rule;
        this.flags = new HashSet<Tag>(flags);
    }

    @Override
    public void check(Element element) throws SemanticException {
        if (element instanceof Node && ((Node)element).isReference()) {
            return;
        }
        this.checkParameter(element, ((Parametrized)((Object)element)).parameters());
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Primitive type() {
        return this.type;
    }

    @Override
    public String aspect() {
        return this.aspect;
    }

    @Override
    public Size size() {
        return this.size;
    }

    @Override
    public int position() {
        return this.position;
    }

    @Override
    public String scope() {
        return this.scope;
    }

    @Override
    public VariableRule rule() {
        return this.rule;
    }

    @Override
    public List<Tag> flags() {
        return Collections.unmodifiableList(new ArrayList<Tag>(this.flags));
    }

    private void checkParameter(Element element, List<Parameter> parameters) throws SemanticException {
        Parameter parameter = PrimitiveParameter.findParameter(parameters, this.aspect, this.name, this.position);
        if (parameter == null) {
            if (this.size.isRequired() && (!(element instanceof Node) || this.isNotAbstractNode(element))) {
                this.error = ParameterConstraint.ParameterError.NOT_FOUND;
                this.error(element, null, this.error);
            }
            return;
        }
        if (this.isCompatible(parameter)) {
            parameter.name(this.name());
            parameter.type(this.type());
            parameter.aspect(this.aspect);
            parameter.scope(this.scope);
            if (parameter.rule() == null) {
                parameter.rule(this.rule());
            } else {
                this.fillRule(parameter);
            }
            if (this.compliesWithTheConstraints(parameter)) {
                if (this.isReferenceInWord(parameter)) {
                    parameter.values(parameter.originalValues());
                }
                parameter.flags(this.flags());
            } else {
                this.error = ParameterConstraint.ParameterError.RULE;
                this.error(element, parameter, this.error);
            }
            if (!this.size().accept(parameter.values())) {
                this.error = ParameterConstraint.ParameterError.SIZE;
                this.error(element, parameter, this.error);
            } else {
                parameter.multiple(!this.size().isSingle());
            }
        } else {
            this.error = ParameterConstraint.ParameterError.TYPE;
            this.error(element, parameter, this.error);
        }
    }

    private void fillRule(Parameter parameter) {
        VariableRule toFill = parameter.rule();
        if (toFill instanceof NativeRule && this.rule() instanceof NativeObjectRule) {
            parameter.rule(new NativeObjectRule(((NativeObjectRule)this.rule()).declaredType()));
        } else if (this.rule() != null && toFill instanceof NativeRule && this.rule() instanceof NativeRule) {
            NativeRule nativeRule = (NativeRule)this.rule();
            ((NativeRule)toFill).interfaceClass(nativeRule.interfaceClass());
            ((NativeRule)toFill).signature(nativeRule.signature());
            ((NativeRule)toFill).imports(nativeRule.imports());
        }
    }

    private boolean isCompatible(Parameter parameter) {
        List<Object> values = parameter.values();
        if (values.isEmpty()) {
            return true;
        }
        Primitive inferredType = PrimitiveTypeCompatibility.inferType(values.get(0));
        return inferredType != null && PrimitiveTypeCompatibility.checkCompatiblePrimitives(this.type(), inferredType, parameter.isMultiple());
    }

    private boolean compliesWithTheConstraints(Parameter rejectable) {
        return this.rule == null || this.accept(rejectable, this.rule);
    }

    private boolean accept(Parameter parameter, Rule rule) {
        try {
            return rule instanceof NativeRule || parameter.values().isEmpty() || parameter.values().get(0) instanceof EmptyNode || rule.accept(this.isReferenceInWord(parameter) ? parameter.originalValues() : parameter.values(), parameter.metric());
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isReferenceInWord(Parameter parameter) {
        return this.type().equals((Object)Primitive.WORD) && !parameter.values().isEmpty() && parameter.values().get(0) instanceof Node;
    }

    @Override
    protected void error(Element element, Parameter parameter, ParameterConstraint.ParameterError errorType) throws SemanticException {
        switch (errorType) {
            case TYPE: {
                throw new SemanticException(new SemanticNotification(SemanticNotification.Level.ERROR, "reject.invalid.parameter.value.type", parameter, Arrays.asList(this.name(), this.type.getName())));
            }
            case NOT_FOUND: {
                throw new SemanticException(new SemanticNotification(SemanticNotification.Level.RECOVERABLE_ERROR, "required.parameter.in.context", element, Arrays.asList(this.name(), this.type.getName())));
            }
            case SIZE: {
                throw new SemanticException(new SemanticNotification(SemanticNotification.Level.ERROR, this.size().errorMessage(), parameter, this.size().errorParameters()));
            }
            case RULE: {
                throw new SemanticException(new SemanticNotification(this.rule.level(), this.rule().errorMessage() == null || this.rule().errorMessage().isEmpty() ? "rule.not.complains" : this.rule().errorMessage(), parameter, this.rule().errorParameters()));
            }
        }
    }

    public String toString() {
        return "Parameter{" + (Object)((Object)this.type) + "@" + this.name + "}";
    }
}

