/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.lang.semantics.constraints;

import io.intino.tara.lang.model.EmptyNode;
import io.intino.tara.lang.model.Node;
import io.intino.tara.lang.model.Primitive;
import java.io.File;

public class PrimitiveTypeCompatibility {
    private PrimitiveTypeCompatibility() {
    }

    public static boolean checkCompatiblePrimitives(Primitive type, Primitive inferredType, boolean multiple) {
        return type.equals((Object)inferredType) || PrimitiveTypeCompatibility.emptyInfersEmptyList(type, inferredType, multiple) || PrimitiveTypeCompatibility.integerInfersInteger(type, inferredType) || PrimitiveTypeCompatibility.booleanOrFunctionInfersBoolean(type, inferredType) || PrimitiveTypeCompatibility.nativeOrEmptyInfersObject(type, inferredType) || PrimitiveTypeCompatibility.stringInfersString(type, inferredType) || PrimitiveTypeCompatibility.integerInfersDouble(type, inferredType) || PrimitiveTypeCompatibility.integerInfersLong(type, inferredType) || PrimitiveTypeCompatibility.stringFunctionOrEmptyInfersDate(type, inferredType) || PrimitiveTypeCompatibility.stringFunctionOrEmptyInfersInstant(type, inferredType) || PrimitiveTypeCompatibility.stringInfersTime(type, inferredType) || PrimitiveTypeCompatibility.nativeOrEmptyInfersNative(type, inferredType) || PrimitiveTypeCompatibility.emptyInfersReference(type, inferredType) || PrimitiveTypeCompatibility.referenceInfersWord(type, inferredType) || PrimitiveTypeCompatibility.stringOrEmptyInfersFile(type, inferredType);
    }

    private static boolean stringInfersTime(Primitive type, Primitive inferredType) {
        return (inferredType.equals((Object)Primitive.STRING) || inferredType.equals((Object)Primitive.EMPTY)) && type.equals((Object)Primitive.TIME);
    }

    private static boolean stringOrEmptyInfersFile(Primitive type, Primitive inferredType) {
        return (inferredType.equals((Object)Primitive.STRING) || inferredType.equals((Object)Primitive.EMPTY) || inferredType.equals((Object)Primitive.FUNCTION)) && type.equals((Object)Primitive.RESOURCE);
    }

    private static boolean booleanOrFunctionInfersBoolean(Primitive type, Primitive inferredType) {
        return (inferredType.equals((Object)Primitive.BOOLEAN) || inferredType.equals((Object)Primitive.FUNCTION) || inferredType.equals((Object)Primitive.EMPTY)) && type.equals((Object)Primitive.BOOLEAN);
    }

    private static boolean nativeOrEmptyInfersObject(Primitive type, Primitive inferredType) {
        return (inferredType.equals((Object)Primitive.FUNCTION) || inferredType.equals((Object)Primitive.EMPTY)) && type.equals((Object)Primitive.OBJECT);
    }

    private static boolean stringInfersString(Primitive type, Primitive inferredType) {
        return (inferredType.equals((Object)Primitive.STRING) || inferredType.equals((Object)Primitive.FUNCTION) || inferredType.equals((Object)Primitive.EMPTY)) && type.equals((Object)Primitive.STRING);
    }

    private static boolean emptyInfersReference(Primitive type, Primitive inferredType) {
        return (inferredType.equals((Object)Primitive.EMPTY) || inferredType.equals((Object)Primitive.FUNCTION)) && type.equals((Object)Primitive.REFERENCE);
    }

    private static boolean nativeOrEmptyInfersNative(Primitive type, Primitive inferredType) {
        return inferredType.equals((Object)Primitive.FUNCTION) && type.equals((Object)Primitive.FUNCTION);
    }

    private static boolean emptyInfersEmptyList(Primitive type, Primitive inferredType, boolean multiple) {
        return inferredType.equals((Object)Primitive.EMPTY) && !type.equals((Object)Primitive.REFERENCE) && multiple;
    }

    private static boolean stringFunctionOrEmptyInfersDate(Primitive type, Primitive inferredType) {
        return (inferredType.equals((Object)Primitive.STRING) || inferredType.equals((Object)Primitive.FUNCTION) || inferredType.equals((Object)Primitive.EMPTY)) && type.equals((Object)Primitive.DATE);
    }

    private static boolean stringFunctionOrEmptyInfersInstant(Primitive type, Primitive inferredType) {
        return (inferredType.equals((Object)Primitive.STRING) || inferredType.equals((Object)Primitive.FUNCTION) || inferredType.equals((Object)Primitive.EMPTY)) && type.equals((Object)Primitive.INSTANT);
    }

    private static boolean integerInfersDouble(Primitive type, Primitive inferredType) {
        return (inferredType.equals((Object)Primitive.INTEGER) || inferredType.equals((Object)Primitive.FUNCTION) || inferredType.equals((Object)Primitive.EMPTY)) && type.equals((Object)Primitive.DOUBLE);
    }

    private static boolean integerInfersInteger(Primitive type, Primitive inferredType) {
        return (inferredType.equals((Object)Primitive.INTEGER) || inferredType.equals((Object)Primitive.FUNCTION) || inferredType.equals((Object)Primitive.EMPTY)) && type.equals((Object)Primitive.INTEGER);
    }

    private static boolean integerInfersLong(Primitive type, Primitive inferredType) {
        return (inferredType.equals((Object)Primitive.INTEGER) || inferredType.equals((Object)Primitive.FUNCTION) || inferredType.equals((Object)Primitive.EMPTY)) && type.equals((Object)Primitive.LONG);
    }

    private static boolean referenceInfersWord(Primitive type, Primitive inferredType) {
        return type.equals((Object)Primitive.WORD) && inferredType.equals((Object)Primitive.REFERENCE);
    }

    public static Primitive inferType(Object value) {
        if (value == null || value instanceof EmptyNode) {
            return Primitive.EMPTY;
        }
        if (value instanceof String) {
            return Primitive.STRING;
        }
        if (value instanceof Primitive.Reference || value instanceof Node) {
            return Primitive.REFERENCE;
        }
        if (value instanceof Double) {
            return Primitive.DOUBLE;
        }
        if (value instanceof Boolean) {
            return Primitive.BOOLEAN;
        }
        if (value instanceof Integer) {
            return Primitive.INTEGER;
        }
        if (value instanceof Long) {
            return Primitive.LONG;
        }
        if (value instanceof File) {
            return Primitive.RESOURCE;
        }
        if (value instanceof Primitive.Expression) {
            return Primitive.FUNCTION;
        }
        if (value instanceof Primitive.MethodReference) {
            return Primitive.FUNCTION;
        }
        return null;
    }
}

