/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.lang.model.rules.variable;

import io.intino.tara.lang.model.Primitive;
import io.intino.tara.lang.model.rules.variable.VariableRule;
import java.util.Collections;
import java.util.List;

public class WordRule
implements VariableRule<List<Primitive.Reference>> {
    private static final String REJECT_INVALID_WORD_VALUES = "reject.invalid.word.values";
    private List<Object> parameters;
    private List<String> words;
    private String externalWordClass;
    private String message = "reject.invalid.word.values";

    public WordRule(List<String> words) {
        this.words = words;
        this.externalWordClass = null;
        this.parameters = Collections.singletonList(String.join((CharSequence)", ", words));
    }

    public WordRule(List<String> words, String externalWordClass) {
        this.words = words;
        this.externalWordClass = externalWordClass;
        this.parameters = Collections.singletonList(String.join((CharSequence)", ", words));
    }

    public List<String> words() {
        return this.words;
    }

    public boolean isCustom() {
        return this.externalWordClass != null;
    }

    public String externalWordClass() {
        return this.externalWordClass;
    }

    @Override
    public boolean accept(List<Primitive.Reference> references) {
        for (Primitive.Reference reference : references) {
            if (this.words.contains(reference.get())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean accept(List<Primitive.Reference> references, String metric) {
        return this.accept(references);
    }

    @Override
    public String errorMessage() {
        return this.message;
    }

    @Override
    public List<Object> errorParameters() {
        return this.parameters;
    }
}

