/*
 * Decompiled with CFR 0.152.
 */
package io.intino.tara.lang.model.rules.variable;

import io.intino.tara.lang.model.Metric;
import io.intino.tara.lang.model.Rule;
import io.intino.tara.lang.model.rules.CustomRule;
import io.intino.tara.lang.model.rules.variable.VariableRule;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;

public class VariableCustomRule
implements VariableRule<List<Object>>,
CustomRule {
    private static final Logger LOG = Logger.getGlobal();
    private final String aClass;
    private Class<?> loadedClass;
    private VariableRule object;
    private String qualifiedName;
    private File classFile;

    public VariableCustomRule(String aClass) {
        this.aClass = aClass;
    }

    @Override
    public boolean accept(List<Object> values) {
        return this.loadedClass == null || !this.isMetric() && this.invokeWith(values);
    }

    @Override
    public boolean accept(List<Object> values, String metric) {
        return this.loadedClass == null || this.isMetric() || this.accept(values);
    }

    @Override
    public String errorMessage() {
        return "";
    }

    @Override
    public List<Object> errorParameters() {
        return Collections.emptyList();
    }

    public String getDefaultUnit() {
        for (Field field : this.loadedClass.getDeclaredFields()) {
            if (!field.isEnumConstant()) continue;
            return field.getName();
        }
        return null;
    }

    public boolean isMetric() {
        if (this.loadedClass == null || !this.loadedClass.isEnum()) {
            return false;
        }
        for (Class<?> aClass : this.loadedClass.getInterfaces()) {
            if (!aClass.getName().equals(Metric.class.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Class<?> loadedClass() {
        return this.loadedClass;
    }

    public String qualifiedName() {
        return this.loadedClass == null ? this.qualifiedName : this.loadedClass.getName();
    }

    @Override
    public void setLoadedClass(Class<?> loadedClass) {
        this.loadedClass = loadedClass;
        try {
            this.object = (VariableRule)this.loadedClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            // empty catch block
        }
    }

    @Override
    public void classFile(File file) {
        this.classFile = file;
    }

    @Override
    public File classFile() {
        return this.classFile;
    }

    @Override
    public String getExternalWordClass() {
        return this.aClass;
    }

    private boolean invokeWith(List<Object> values) {
        try {
            Rule rule = (Rule)this.loadedClass.newInstance();
            if (this.acceptAsList(rule)) {
                return rule.accept(values);
            }
            for (Object value : values) {
                if (rule.accept(value)) continue;
                return false;
            }
            return true;
        }
        catch (IllegalAccessException | InstantiationException e) {
            LOG.severe(e.getMessage());
            return false;
        }
    }

    private boolean acceptAsList(Rule rule) {
        try {
            return rule.getClass().getMethod("accept", List.class) != null;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public void qualifiedName(String qualifiedName) {
        this.qualifiedName = qualifiedName;
    }
}

