/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.sigar;

import io.intino.consul.sigar.ProcessQuery;
import java.io.IOException;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.ptql.ProcessFinder;

public class SigarProcessManager {
    private long pid = -1L;

    public SigarProcessManager(ProcessQuery query) throws IOException {
        try (Sigar sigar = new Sigar();){
            long[] pids;
            for (long process : pids = ProcessFinder.find(sigar, "State.Name.eq=" + query.getCommand())) {
                String[] arguments = sigar.getProcArgs(process);
                if (arguments == null || !this.argumentMatches(arguments, query.getArgument())) continue;
                this.pid = process;
            }
        }
    }

    public void kill() throws IOException {
        try (Sigar sigar = new Sigar();){
            sigar.kill(this.pid, Sigar.getSigNum("KILL"));
        }
    }

    private boolean argumentMatches(String[] arguments, String expected) {
        for (String argument : arguments) {
            if (!argument.contains(expected)) continue;
            return true;
        }
        return false;
    }
}

