/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.box.rest.resources;

import io.intino.alexandria.exceptions.BadRequest;
import io.intino.alexandria.rest.Resource;
import io.intino.alexandria.rest.spark.SparkContext;
import io.intino.alexandria.rest.spark.SparkManager;
import io.intino.alexandria.rest.spark.SparkPushService;
import io.intino.consul.box.ConsulBox;
import io.intino.consul.box.actions.PostChangeProcessStatusAction;

public class PostChangeProcessStatusResource
implements Resource {
    private ConsulBox box;
    private SparkManager<SparkPushService> manager;

    public PostChangeProcessStatusResource(ConsulBox box, SparkManager manager) {
        this.box = box;
        this.manager = manager;
    }

    @Override
    public void execute() throws BadRequest {
        this.write(this.fill(new PostChangeProcessStatusAction()).execute());
    }

    private PostChangeProcessStatusAction fill(PostChangeProcessStatusAction action) {
        action.box = this.box;
        action.context = this.context();
        action.process = this.manager.fromPath("process", String.class);
        action.status = this.manager.fromQuery("status", String.class);
        action.debugging = this.manager.fromQueryOrDefault("debugging", Boolean.class, "false");
        return action;
    }

    private void write(Boolean object) {
        this.manager.write(object);
    }

    private SparkContext context() {
        SparkContext context = new SparkContext(this.manager);
        return context;
    }
}

