/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.box.actions;

import io.intino.alexandria.logger.Logger;
import io.intino.consul.box.ConsulBox;
import io.intino.consul.box.ProcessFinder;
import io.intino.consul.box.actions.ProcessStatusAction;
import io.intino.consul.box.actions.SynchronizedAction;
import java.util.concurrent.atomic.AtomicBoolean;

public class StartProcessAction
extends SynchronizedAction {
    public ConsulBox box;
    public String processId;
    private static AtomicBoolean isProcessing = new AtomicBoolean(false);

    public StartProcessAction() {
    }

    public StartProcessAction(ConsulBox box, String processId) {
        this.box = box;
        this.processId = processId;
    }

    public synchronized Boolean execute() {
        this.lock();
        boolean start = this.box.processManager().start(ProcessFinder.processFromIdentifier(this.box.graph(), this.processId));
        if (start) {
            new Thread(() -> new ProcessStatusAction(this.box, this.processId).execute()).start();
        }
        this.unlock();
        return start;
    }

    @Override
    protected void lock() {
        if (isProcessing.get()) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                Logger.error(e);
            }
        }
        isProcessing.set(true);
    }

    @Override
    protected void unlock() {
        isProcessing.set(false);
        this.notify();
    }
}

