/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.box.actions;

import io.intino.alexandria.logger.Logger;
import io.intino.consul.box.ConsulBox;
import io.intino.consul.box.ProcessFinder;
import io.intino.consul.box.actions.SynchronizedAction;
import java.util.concurrent.atomic.AtomicBoolean;

public class RestartProcessAction
extends SynchronizedAction {
    public ConsulBox box;
    public String processId;
    private static AtomicBoolean isProcessing = new AtomicBoolean(false);

    public RestartProcessAction() {
    }

    public RestartProcessAction(ConsulBox box, String processId) {
        this.processId = processId;
        this.box = box;
    }

    public synchronized Boolean execute() {
        try {
            this.lock();
            boolean restart = this.box.processManager().restart(ProcessFinder.processFromIdentifier(this.box.graph(), this.processId));
            this.unlock();
            return restart;
        }
        catch (Throwable e) {
            return false;
        }
    }

    @Override
    protected void lock() {
        if (isProcessing.get()) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                Logger.error(e);
            }
        }
        isProcessing.set(true);
    }

    @Override
    protected void unlock() {
        isProcessing.set(false);
        this.notify();
    }
}

