/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.box.actions;

import io.intino.alexandria.logger.Logger;
import io.intino.consul.box.ConsulBox;
import io.intino.consul.box.ProcessFinder;
import io.intino.consul.box.actions.SynchronizedAction;
import io.intino.consul.box.schemas.Operation;
import io.intino.consul.box.schemas.OperationResult;
import io.intino.consul.graph.Process;
import io.intino.consul.process.ProcessConnector;
import io.intino.consul.process.ProcessManager;
import java.util.concurrent.atomic.AtomicBoolean;

public class ProcessOperationAction
extends SynchronizedAction {
    public ConsulBox box;
    public Operation operation;
    private static AtomicBoolean isProcessing = new AtomicBoolean(false);

    public synchronized OperationResult execute() {
        try {
            this.lock();
            Process process = ProcessFinder.processFromIdentifier(this.box.graph(), this.operation.processId());
            ProcessManager processManager = this.box.processManager();
            boolean running = processManager.isRunning(ProcessFinder.processFromIdentifier(this.box.graph(), this.operation.processId()));
            if (!running) {
                this.unlock();
                return new OperationResult().success(false).remarks("Process is not running");
            }
            ProcessConnector connector = new ProcessConnector(process);
            connector.connect();
            OperationResult invoke = connector.invoke(this.operation);
            connector.close();
            this.unlock();
            return invoke;
        }
        catch (Throwable e) {
            return new OperationResult().success(false).remarks(e.getMessage());
        }
    }

    @Override
    protected void lock() {
        if (isProcessing.get()) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                Logger.error(e);
            }
        }
        isProcessing.set(true);
    }

    @Override
    protected void unlock() {
        isProcessing.set(false);
        this.notify();
    }
}

