/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.box.actions;

import io.intino.alexandria.logger.Logger;
import io.intino.consul.box.ConsulBox;
import io.intino.consul.box.ProcessFinder;
import io.intino.consul.box.actions.SynchronizedAction;
import io.intino.consul.graph.Process;
import java.util.concurrent.atomic.AtomicBoolean;

public class ParameterAction
extends SynchronizedAction {
    private static AtomicBoolean isProcessing = new AtomicBoolean(false);
    public String processId;
    public ConsulBox box;
    public String name;
    public String value;

    public synchronized Boolean execute() {
        this.lock();
        Process process = ProcessFinder.processFromIdentifier(this.box.graph(), this.processId);
        if (process == null) {
            this.unlock();
            return false;
        }
        Process.Parameter parameter = process.parameterList().stream().filter(p -> this.name.equals(p.name())).findFirst().orElse(null);
        if (parameter == null) {
            this.unlock();
            return false;
        }
        parameter.value(this.value);
        parameter.save$();
        this.unlock();
        return true;
    }

    @Override
    protected void lock() {
        if (isProcessing.get()) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                Logger.error(e);
            }
        }
        isProcessing.set(true);
    }

    @Override
    protected void unlock() {
        isProcessing.set(false);
        this.notify();
    }
}

