/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.box.actions;

import io.intino.alexandria.logger.Logger;
import io.intino.consul.box.ConsulBox;
import io.intino.consul.box.ProcessFinder;
import io.intino.consul.box.actions.SynchronizedAction;
import java.util.concurrent.atomic.AtomicBoolean;

public class DebugProcessAction
extends SynchronizedAction {
    public String processId;
    public Integer port;
    public ConsulBox box;
    private static AtomicBoolean isProcessing = new AtomicBoolean(false);

    public synchronized Boolean execute() {
        this.lock();
        boolean debug = this.box.processManager().debug(ProcessFinder.processFromIdentifier(this.box.graph(), this.processId), this.port);
        this.unlock();
        return debug;
    }

    @Override
    protected void lock() {
        if (isProcessing.get()) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                Logger.error(e);
            }
        }
        isProcessing.set(true);
    }

    @Override
    protected void unlock() {
        isProcessing.set(false);
        this.notify();
    }
}

