/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.scheduler.directory;

import io.intino.alexandria.scheduler.directory.DirectoryTask;
import java.io.File;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Iterator;

public class DirectorySentinel {
    private DirectoryTask task;
    private WatchService watcher;

    public DirectorySentinel(File directory, DirectoryTask task, Event ... events) {
        try {
            this.watcher = FileSystems.getDefault().newWatchService();
            this.task = task;
            directory.toPath().register(this.watcher, this.kindsOf(events));
        }
        catch (IOException e) {
            this.watcher = null;
        }
    }

    public void watch() {
        try {
            WatchKey key;
            boolean valid;
            do {
                key = this.watcher.take();
                Iterator<WatchEvent<?>> iterator = key.pollEvents().iterator();
                while (iterator.hasNext()) {
                    WatchEvent<?> event;
                    WatchEvent<?> ev = event = iterator.next();
                    new Thread(() -> this.task.execute(((Path)ev.context()).toFile(), this.eventOf(ev.kind()))).start();
                }
            } while (valid = key.reset());
        }
        catch (InterruptedException | ClosedWatchServiceException ex) {
            ex.printStackTrace();
            return;
        }
    }

    public void stop() {
        try {
            this.watcher.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private WatchEvent.Kind[] kindsOf(Event[] events) {
        ArrayList<WatchEvent.Kind<Path>> list = new ArrayList<WatchEvent.Kind<Path>>();
        for (Event event : events) {
            if (event.equals((Object)Event.OnCreate)) {
                list.add(StandardWatchEventKinds.ENTRY_CREATE);
                continue;
            }
            if (event.equals((Object)Event.OnModify)) {
                list.add(StandardWatchEventKinds.ENTRY_MODIFY);
                continue;
            }
            if (!event.equals((Object)Event.OnDelete)) continue;
            list.add(StandardWatchEventKinds.ENTRY_DELETE);
        }
        return list.toArray(new WatchEvent.Kind[list.size()]);
    }

    private Event eventOf(WatchEvent.Kind kind) {
        if (kind.equals(StandardWatchEventKinds.ENTRY_CREATE)) {
            return Event.OnCreate;
        }
        if (kind.equals(StandardWatchEventKinds.ENTRY_MODIFY)) {
            return Event.OnModify;
        }
        return Event.OnDelete;
    }

    public static enum Event {
        OnCreate,
        OnModify,
        OnDelete;

    }
}

