/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.rest.spark;

import io.intino.alexandria.Resource;
import io.intino.alexandria.rest.spark.PushService;
import io.intino.alexandria.rest.spark.SparkReader;
import io.intino.alexandria.rest.spark.SparkSession;
import io.intino.alexandria.rest.spark.SparkWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.MultipartConfigElement;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.Part;
import spark.Request;
import spark.Response;

public class SparkManager<P extends PushService> {
    private static final String XForwardedProto = "X-Forwarded-Proto";
    private static final String XForwardedPath = "X-Forwarded-Path";
    private static final String XForwardedPort = "X-Forwarded-Port";
    protected final P pushService;
    protected final Request request;
    protected final Response response;

    public SparkManager(P pushService, Request request, Response response) {
        this.pushService = pushService;
        this.request = request;
        this.response = response;
        this.setUpMultipartConfiguration();
        this.setUpSessionCookiePath();
    }

    public P pushService() {
        return this.pushService;
    }

    public SparkSession currentSession() {
        String sessionId = this.request.cookie(this.sessionCookieName());
        if (sessionId == null) {
            sessionId = this.request.session().id();
        }
        return (SparkSession)((PushService)this.pushService).session(sessionId);
    }

    public void write(Object object) {
        new SparkWriter(this.response).write(object);
    }

    public void write(Object object, String name) {
        this.write(object, name, false);
    }

    public void write(Object object, String name, boolean embedded) {
        new SparkWriter(this.response).write(object, name, embedded);
    }

    public <T> T fromHeader(String name, Class<T> type) {
        return this.request.headers(name) == null ? null : (T)SparkReader.read(this.request.headers(name), type);
    }

    public <T> T fromHeaderOrDefault(String name, Class<T> type, String defaultValue) {
        return this.request.headers(name) == null ? this.defaultValue(defaultValue, type) : SparkReader.read(this.request.headers(name), type);
    }

    public <T> T fromQuery(String name, Class<T> type) {
        return this.request.queryParams(name) == null ? null : (T)SparkReader.read(this.request.queryParams(name), type);
    }

    public <T> T fromQueryOrDefault(String name, Class<T> type, String defaultValue) {
        return this.request.queryParams(name) == null ? this.defaultValue(defaultValue, type) : SparkReader.read(this.request.queryParams(name), type);
    }

    public <T> T fromQuery(String name, Type type) {
        return this.request.queryParams(name) == null ? null : (T)SparkReader.read(this.request.queryParams(name), type);
    }

    public <T> T fromPath(String name, Class<T> type) {
        return this.request.params(name) == null ? null : (T)SparkReader.read(this.request.params(name), type);
    }

    public <T> T fromPathOrDefault(String name, Class<T> type, String value) {
        return this.request.params(name) == null ? this.defaultValue(value, type) : SparkReader.read(this.request.params(name), type);
    }

    private <T> T defaultValue(String defaultValue, Class<T> type) {
        return SparkReader.read(defaultValue, type);
    }

    public <T> T fromBody(String name, Class<T> type) {
        try {
            if (type.isAssignableFrom(Resource.class) || type.isAssignableFrom(InputStream.class)) {
                return (T)new Resource(name, this.request.raw().getInputStream());
            }
            return SparkReader.read(this.request.body(), type);
        }
        catch (IOException e) {
            return null;
        }
    }

    public <T> T fromForm(String name, Class<T> type) {
        try {
            Part part = this.request.raw().getPart(name);
            return (T)(part != null ? new Resource(part.getName(), part.getInputStream()).metadata().contentType(part.getContentType()) : null);
        }
        catch (IOException | ServletException e) {
            return null;
        }
    }

    public Request request() {
        return this.request;
    }

    public Response response() {
        return this.response;
    }

    public String domain() {
        try {
            URL url = new URL(this.request.raw().getRequestURL().toString());
            String result = url.getHost();
            int port = this.getHeaderPort();
            if (port == -1) {
                port = url.getPort();
            }
            if (port != 80 && port != -1) {
                result = result + ":" + port;
            }
            return result;
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public String baseUrl() {
        String result = this.generateBaseUrl();
        result = this.addHeaderProtocol(result);
        result = this.addHeaderPath(result);
        return result;
    }

    public String basePath() {
        String forwardedPath = this.request.raw().getHeader(XForwardedPath);
        return forwardedPath == null || forwardedPath.equals("") || forwardedPath.equals("/") ? "" : forwardedPath;
    }

    public String getHeader(String name) {
        return this.request.raw().getHeader(name);
    }

    public String realIp() {
        HttpServletRequest raw = this.request.raw();
        String ip = raw.getHeader("X-Real-IP");
        if (ip == null || ip.isEmpty()) {
            ip = raw.getHeader("X-Forwarded-For");
        }
        if (ip != null && !ip.isEmpty()) {
            int indexComma = ip.indexOf(44);
            if (indexComma == -1) {
                return ip;
            }
            return ip.substring(0, indexComma);
        }
        return raw.getRemoteAddr();
    }

    private void setUpMultipartConfiguration() {
        MultipartConfigElement multipartConfigElement = new MultipartConfigElement(System.getProperty("java.io.tmpdir"));
        this.request.raw().setAttribute("org.eclipse.jetty.multipartConfig", multipartConfigElement);
    }

    private void setUpSessionCookiePath() {
        HttpServletRequest request = this.request.raw();
        HttpSession session = request.getSession();
        String sessionCookieName = this.sessionCookieName();
        if (request.getParameter(sessionCookieName) != null) {
            Cookie userCookie = new Cookie(sessionCookieName, request.getParameter(sessionCookieName));
            this.response.raw().addCookie(userCookie);
        } else if (this.request.cookie(sessionCookieName) == null) {
            String sessionId = session.getId();
            Cookie userCookie = new Cookie(sessionCookieName, sessionId);
            this.response.raw().addCookie(userCookie);
        }
    }

    private String sessionCookieName() {
        String sessionCookieName;
        String header = this.request.raw().getHeader(XForwardedPath);
        String string = sessionCookieName = header != null ? header.replace("/", "") : "federacion";
        if (sessionCookieName.isEmpty()) {
            sessionCookieName = "federacion";
        }
        return sessionCookieName;
    }

    private String generateBaseUrl() {
        try {
            URL url = new URL(this.request.raw().getRequestURL().toString());
            String baseUrl = url.getProtocol() + "://" + url.getHost();
            int port = this.getHeaderPort();
            if (port == -1) {
                port = url.getPort();
            }
            if (port != 80 && port != -1) {
                baseUrl = baseUrl + ":" + port;
            }
            return baseUrl;
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private String addHeaderProtocol(String url) {
        String forwardedProto = this.request.raw().getHeader(XForwardedProto);
        if (forwardedProto == null || !forwardedProto.equals("https")) {
            return url;
        }
        return url.replace("http:", "https:");
    }

    private String addHeaderPath(String url) {
        String forwardedPath = this.request.raw().getHeader(XForwardedPath);
        if (forwardedPath == null) {
            return url;
        }
        return url + (forwardedPath.equals("") || forwardedPath.equals("/") ? "" : forwardedPath);
    }

    private int getHeaderPort() {
        String forwardedPort = this.request.raw().getHeader(XForwardedPort);
        if (forwardedPort == null || forwardedPort.isEmpty()) {
            return -1;
        }
        return Integer.valueOf(forwardedPort);
    }

    public void redirect(String location) {
        this.response.redirect(location);
    }
}

