/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.rest.pushservice;

import io.intino.alexandria.rest.pushservice.Client;
import io.intino.alexandria.rest.pushservice.ClientProvider;
import io.intino.alexandria.rest.pushservice.Session;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SessionManager<S extends Session<C>, C extends Client>
implements ClientProvider<C> {
    private final Map<String, S> sessionMap = new HashMap<String, S>();
    private final Map<String, C> clientMap = new HashMap<String, C>();
    private final Map<Long, C> linkClientMap = new HashMap<Long, C>();

    public List<S> sessions() {
        return new ArrayList<S>(this.sessionMap.values());
    }

    public S session(String id) {
        return (S)((Session)this.sessionMap.getOrDefault(id, null));
    }

    public void register(S session) {
        session.clientProvider(this);
        this.sessionMap.putIfAbsent(session.id(), session);
    }

    public void unRegister(S session) {
        session.clients().forEach(this::unRegister);
        this.sessionMap.remove(session.id());
    }

    @Override
    public List<C> clients(String sessionId) {
        return this.clientMap.values().stream().filter(c -> c.sessionId().equals(sessionId)).collect(Collectors.toList());
    }

    @Override
    public C client(String id) {
        return (C)((Client)this.clientMap.get(id));
    }

    @Override
    public C client() {
        return (C)((Client)this.linkClientMap.get(Thread.currentThread().getId()));
    }

    public C client(String sessionId, String id) {
        return this.session(sessionId).client(id);
    }

    public C currentClient() {
        return (C)((Client)this.linkClientMap.get(Thread.currentThread().getId()));
    }

    public void register(C client) {
        this.clientMap.put(client.id(), client);
    }

    public void unRegister(C client) {
        client.destroy();
        this.clientMap.remove(client.id());
    }

    public void linkToThread(C client) {
        long id = Thread.currentThread().getId();
        this.linkClientMap.put(id, client);
    }

    public void unlinkFromThread() {
        long id = Thread.currentThread().getId();
        this.linkClientMap.remove(id);
    }
}

