/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.message;

import io.intino.alexandria.message.Message;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Stack;

public class MessageReader
implements Iterable<Message>,
Iterator<Message> {
    private Loader loader;
    private Message next;

    public MessageReader(String str) {
        this(new ByteArrayInputStream(str.getBytes()));
    }

    public MessageReader(InputStream is) {
        this.loader = new Loader(new BufferedInputStream(is));
        this.next = this.loader.load();
    }

    @Override
    public Iterator<Message> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public Message next() {
        Message current = this.next;
        this.next = this.loader.load();
        return current;
    }

    public void close() {
        this.loader.close();
    }

    private static boolean isHeader(String line) {
        return line != null && line.length() > 0 && line.charAt(0) == '[';
    }

    private static boolean isAttachmentHeader(String line) {
        return line != null && line.equals("[&]");
    }

    private static boolean isInnerHeader(String line) {
        return MessageReader.isHeader(line) && line.contains(".");
    }

    private static boolean isMultiline(String line) {
        return line.length() > 0 && line.charAt(0) == '\t';
    }

    private static class Cursor {
        private InputStream is;
        private Scanner scanner;
        private String next;
        private int pos;

        Cursor(InputStream is) {
            this.is = is;
            this.mark();
        }

        boolean hasAttachmentHeader() {
            return MessageReader.isAttachmentHeader(this.next);
        }

        boolean hasMainHeader() {
            return MessageReader.isHeader(this.next) && !MessageReader.isInnerHeader(this.next);
        }

        private static boolean shouldTrim(String line) {
            return !MessageReader.isMultiline(line) && !MessageReader.isHeader(line);
        }

        private static String trim(String line) {
            int[] index = Cursor.splitIndex(line.toCharArray());
            return line.substring(0, index[0] + 1) + ":" + line.substring(index[1]);
        }

        private static int[] splitIndex(char[] data) {
            int index = -1;
            while (++index < data.length && data[index] != ':' && data[index] != '=') {
            }
            int[] result = new int[]{index, index};
            do {
                result[0] = result[0] - 1;
            } while (result[0] >= 0 && data[result[0]] == ' ');
            do {
                result[1] = result[1] + 1;
            } while (result[1] < data.length && data[result[1]] == ' ');
            return result;
        }

        private static String normalize(String line) {
            return line == null ? null : (line.isEmpty() ? "" : (Cursor.shouldTrim(line) ? Cursor.trim(line) : line));
        }

        boolean hasNext() {
            return this.next != null;
        }

        String next() {
            String line = this.next;
            this.next = this.readNext();
            return line;
        }

        String readNext() {
            return this.scanner.hasNext() ? this.read(this.scanner.nextLine()) : null;
        }

        byte[] readBlob() throws IOException {
            byte[] buffer = new byte[this.blobSize()];
            this.is.reset();
            this.is.skip(this.pos);
            this.is.read(buffer);
            this.is.skip(2L);
            this.mark();
            return Base64.getDecoder().decode(buffer);
        }

        private String read(String line) {
            this.pos += line.length() + 1;
            return Cursor.normalize(line);
        }

        String blobId() {
            return this.next.split(":")[0];
        }

        int blobSize() {
            return Integer.valueOf(this.next.split(":")[1]);
        }

        void mark() {
            this.is.mark(16384);
            this.scanner = new Scanner(this.is);
            this.pos = 0;
            this.next = this.readNext();
        }

        Block block() {
            return new Block(this.stripBrackets(this.next));
        }

        private String stripBrackets(String line) {
            return line.substring(1, line.length() - 1);
        }

        boolean isEmpty() {
            return this.next.isEmpty();
        }
    }

    private static class Block
    implements Iterable<String[]> {
        private final String header;
        private final Stack<String> lines;

        Block(String header) {
            this.header = header;
            this.lines = new Stack();
        }

        void add(String line) {
            if (line.isEmpty()) {
                return;
            }
            this.lines.push(this.ifMultilineMerge(line));
        }

        private String ifMultilineMerge(String line) {
            return line.startsWith("\t") ? this.previous() + line.substring(1) : line;
        }

        private String previous() {
            String pop = this.lines.pop();
            return pop + (pop.endsWith(":") ? "" : "\n");
        }

        @Override
        public Iterator<String[]> iterator() {
            return new Iterator<String[]>(){
                Iterator<String> iterator;
                {
                    this.iterator = lines.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.iterator.hasNext();
                }

                @Override
                public String[] next() {
                    String line = this.iterator.next();
                    int idx = line.indexOf(58);
                    return new String[]{line.substring(0, idx), idx == line.length() - 1 ? "" : line.substring(idx + 1)};
                }
            };
        }
    }

    private static class Loader {
        private final BufferedInputStream is;
        private final List<Message> scopes;
        private Cursor cursor;

        Loader(BufferedInputStream is) {
            this.is = is;
            this.scopes = new ArrayList<Message>();
            this.cursor = new Cursor(is);
        }

        Message load() {
            try {
                return this.load(this.blocks());
            }
            catch (IOException e) {
                return null;
            }
        }

        private Message load(List<Block> blocks) throws IOException {
            return blocks.isEmpty() ? null : this.toMessage(blocks).put(this.attachments());
        }

        private Message toMessage(List<Block> blocks) {
            this.scopes.clear();
            for (Block block : blocks) {
                this.scopes.add(this.createMessage(block));
            }
            return this.scopes.get(0);
        }

        private List<Block> blocks() {
            ArrayList<Block> blocks = new ArrayList<Block>();
            blocks.clear();
            Block block = new Block("");
            while (this.cursor.hasNext()) {
                if (MessageReader.isHeader(this.cursor.next)) {
                    if (this.cursor.hasAttachmentHeader() || this.cursor.hasMainHeader() && !blocks.isEmpty()) break;
                    block = this.cursor.block();
                    blocks.add(block);
                    this.cursor.next();
                    continue;
                }
                block.add(this.cursor.next());
            }
            return blocks;
        }

        private Map<String, byte[]> attachments() throws IOException {
            if (!this.cursor.hasAttachmentHeader()) {
                return new HashMap<String, byte[]>();
            }
            this.cursor.next();
            HashMap<String, byte[]> attachments = new HashMap<String, byte[]>();
            while (this.cursor.hasNext()) {
                if (this.cursor.isEmpty()) {
                    this.cursor.next();
                } else {
                    attachments.put(this.cursor.blobId(), this.cursor.readBlob());
                }
                if (!this.cursor.hasMainHeader()) continue;
                break;
            }
            return attachments;
        }

        private static Message create(Block block) {
            Message message = new Message(Loader.typeIn(block.header));
            for (String[] data : block) {
                if (data[1].isEmpty()) continue;
                message.set(data[0], MessageReader.isMultiline(data[1]) ? data[1].substring(1) : data[1]);
            }
            return message;
        }

        private static String typeIn(String line) {
            String[] path = Loader.typesIn(line);
            return path[path.length - 1];
        }

        private static String[] typesIn(String line) {
            return line.split("\\.");
        }

        private Message createMessage(Block block) {
            Message owner = this.scopeOf(block);
            Message message = Loader.create(block);
            if (owner != null) {
                owner.add(message);
            }
            return message;
        }

        private Message scopeOf(Block block) {
            int depth = this.depthOf(block.header) - 1;
            this.scopes.subList(depth + 1, this.scopes.size()).clear();
            return depth >= 0 ? this.scopes.get(depth) : null;
        }

        private int depthOf(String header) {
            int count = 0;
            for (char c : header.toCharArray()) {
                if (c != '.') continue;
                ++count;
            }
            return count;
        }

        void close() {
            try {
                this.is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

