/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.event;

import io.intino.alexandria.Scale;
import io.intino.alexandria.Timetag;
import io.intino.alexandria.event.Event;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.message.MessageReader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

class EventOutBox {
    private static final String INL = ".inl";
    private final File directory;
    private List<File> files;

    EventOutBox(File directory) {
        this.directory = directory.getAbsoluteFile();
        this.files = new ArrayList<File>();
        if (!directory.exists()) {
            directory.mkdirs();
        } else {
            this.reloadOutBox();
        }
    }

    void push(String channel, Event event) {
        try {
            Files.write(new File(this.directory, channel + "#" + this.timetag(event) + "#" + UUID.randomUUID().toString() + INL).toPath(), event.toString().getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    Map.Entry<String, Event> get() {
        this.files.sort(Comparator.comparingLong(File::lastModified));
        if (this.files.isEmpty()) {
            return null;
        }
        try {
            File file = this.files.get(0);
            String inl = Files.readString(file.toPath());
            if (inl.isEmpty() || inl.isBlank()) {
                return null;
            }
            return new AbstractMap.SimpleEntry<String, Event>(this.tank(file), new Event(new MessageReader(inl).next()));
        }
        catch (IOException e) {
            Logger.error(e);
            return null;
        }
    }

    void pop() {
        this.reloadOutBox();
        if (this.files.isEmpty()) {
            return;
        }
        this.files.get(0).delete();
        this.files.remove(0);
    }

    private String timetag(Event event) {
        return new Timetag(LocalDateTime.ofInstant(event.ts(), ZoneOffset.UTC), Scale.Minute).toString();
    }

    private String tank(File file) {
        return file.getName().substring(0, file.getName().indexOf("#"));
    }

    boolean isEmpty() {
        return this.reloadOutBox().isEmpty();
    }

    private List<File> reloadOutBox() {
        if (this.files.isEmpty()) {
            this.files = new ArrayList<File>(Arrays.asList(Objects.requireNonNull(this.directory.listFiles(f -> f.getName().endsWith(INL)))));
            this.files.sort(Comparator.comparingLong(File::lastModified));
        }
        return this.files;
    }
}

