/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.monitoring.box;

import com.google.gson.JsonDeserializer;
import com.google.gson.JsonSerializer;
import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.exceptions.InternalServerError;
import io.intino.alexandria.exceptions.Unauthorized;
import io.intino.alexandria.restaccessor.OutBox;
import io.intino.alexandria.restaccessor.RequestBuilder;
import io.intino.alexandria.restaccessor.Response;
import io.intino.alexandria.restaccessor.adapters.RequestAdapter;
import io.intino.alexandria.restaccessor.adapters.ResponseAdapter;
import io.intino.alexandria.restaccessor.core.RestAccessorNotifier;
import io.intino.cesar.monitoring.box.schemas.BotResponse;
import java.io.File;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class ApiAccessor {
    private final URL url;
    private final RestAccessorNotifier notifier = new RestAccessorNotifier();
    private int timeoutMillis = 120000;
    private OutBox outBox = null;
    private Map<String, String> additionalHeaders = new HashMap<String, String>();
    private final String token;

    public ApiAccessor(URL url, String token) {
        this.url = url;
        this.token = token;
    }

    public ApiAccessor(URL url, int timeoutMillis, String token) {
        this.url = url;
        this.timeoutMillis = timeoutMillis;
        this.token = token;
    }

    public ApiAccessor(URL url, int timeoutMillis, File outBoxDirectory, int intervalRetrySeconds, String token) {
        this.url = url;
        this.timeoutMillis = timeoutMillis;
        this.outBox = new OutBox(outBoxDirectory, intervalRetrySeconds);
        this.token = token;
    }

    public void addCommonHeader(String name, String value) {
        this.additionalHeaders.put(name, value);
    }

    public void addRequestSerializer(Type type, JsonSerializer<?> adapter) {
        RequestAdapter.addCustomAdapter((Type)type, adapter);
    }

    public void addResponseDeserializer(Type type, JsonDeserializer<?> adapter) {
        ResponseAdapter.addCustomAdapter((Type)type, adapter);
    }

    public BotResponse postBot(String conversation, String timeZone) throws Unauthorized, InternalServerError {
        RequestBuilder builder = new RequestBuilder(this.url).timeOut(this.timeoutMillis);
        this.additionalHeaders.forEach((k, v) -> builder.headerParameter(k, v));
        RequestBuilder.Request request = builder.bearerAuth(this.token).entityPart("conversation", (Object)conversation).entityPart("timeZone", (Object)timeZone).build(RequestBuilder.Method.POST, "//bot");
        try {
            Response response = request.execute();
            return (BotResponse)ResponseAdapter.adapt((String)response.content(), BotResponse.class);
        }
        catch (AlexandriaException e) {
            if (e instanceof Unauthorized) {
                throw (Unauthorized)e;
            }
            if (this.outBox != null) {
                this.outBox.push(request);
            }
            throw new InternalServerError(e.message());
        }
    }
}

