package io.intino.cesar.monitoring.box;

import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.net.URL;
import java.lang.reflect.Type;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonDeserializer;
import io.intino.alexandria.exceptions.*;
import io.intino.alexandria.restaccessor.RequestBuilder;
import io.intino.alexandria.restaccessor.core.RestAccessorNotifier;
import io.intino.alexandria.restaccessor.exceptions.RestfulFailure;

import io.intino.cesar.monitoring.box.schemas.*;

public class ApiAccessor {
	private final URL url;
	private final RestAccessorNotifier notifier = new RestAccessorNotifier();
	private int timeoutMillis = 120 * 1_000;
	private io.intino.alexandria.restaccessor.OutBox outBox = null;
	private Map<String, String> additionalHeaders = new HashMap<>();
	private final String token;


	public ApiAccessor(URL url, String token) {
		this.url = url;
		this.token = token;
	}

	public ApiAccessor(URL url, int timeoutMillis, String token) {
		this.url = url;
		this.timeoutMillis = timeoutMillis;
		this.token = token;
	}

	public ApiAccessor(URL url, int timeoutMillis, java.io.File outBoxDirectory, int intervalRetrySeconds, String token) {
		this.url = url;
		this.timeoutMillis = timeoutMillis;
		this.outBox = new io.intino.alexandria.restaccessor.OutBox(outBoxDirectory, intervalRetrySeconds);
		this.token = token;
	}

	public void addCommonHeader(String name, String value) {
		additionalHeaders.put(name, value);
	}

	public void addRequestSerializer(Type type, JsonSerializer<?> adapter) {
		io.intino.alexandria.restaccessor.adapters.RequestAdapter.addCustomAdapter(type, adapter);
	}

	public void addResponseDeserializer(Type type, JsonDeserializer<?> adapter) {
		io.intino.alexandria.restaccessor.adapters.ResponseAdapter.addCustomAdapter(type, adapter);
	}

	public BotResponse postBot(String conversation, String timeZone) throws Unauthorized, InternalServerError {
		RequestBuilder builder = new RequestBuilder(this.url).timeOut(this.timeoutMillis);
		additionalHeaders.forEach((k,v) -> builder.headerParameter(k,v));
		RequestBuilder.Request request = builder
			.bearerAuth(this.token)
			.entityPart("conversation", conversation)
			.entityPart("timeZone", timeZone)
			.build(RequestBuilder.Method.POST, "/" + "/bot");
		try {
			io.intino.alexandria.restaccessor.Response response = request.execute();
			return io.intino.alexandria.restaccessor.adapters.ResponseAdapter.adapt(response.content(), BotResponse.class);
		} catch (AlexandriaException e) {
			if (e instanceof Unauthorized) throw ((Unauthorized) e);
			if (outBox != null) outBox.push(request);
			throw new InternalServerError(e.message());
		}
	}


}