package io.intino.cesar.datahub;

import io.intino.alexandria.logger.Logger;

import java.io.File;
import io.intino.alexandria.datalake.Datalake.EventStore.Tank;
import io.intino.alexandria.datalake.file.FileDatalake;

public class Datalake {
	private final io.intino.alexandria.datalake.Datalake datalake;

	public Datalake(File file) {
		this.datalake = new FileDatalake(file);
	}

	public Tank processStatus() {
		return this.datalake.eventStore().tank("consul.process.ProcessStatus");
	}

	public Tank processLog() {
		return this.datalake.eventStore().tank("consul.process.ProcessLog");
	}

	public Tank serverLog() {
		return this.datalake.eventStore().tank("consul.server.ServerLog");
	}

	public Tank serverInfo() {
		return this.datalake.eventStore().tank("consul.server.ServerInfo");
	}

	public Tank serverStatus() {
		return this.datalake.eventStore().tank("consul.server.ServerStatus");
	}

	public Tank serverBoot() {
		return this.datalake.eventStore().tank("consul.server.ServerBoot");
	}

	public Tank infrastructureOperation() {
		return this.datalake.eventStore().tank("cesar.InfrastructureOperation");
	}

	public Tank processOperation() {
		return this.datalake.eventStore().tank("cesar.ProcessOperation");
	}
}