/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.datahub;

import io.intino.alexandria.Scale;
import io.intino.alexandria.Timetag;
import io.intino.alexandria.event.Event;
import io.intino.alexandria.event.SessionEvent;
import io.intino.alexandria.ingestion.EventSession;
import io.intino.alexandria.ingestion.FS;
import io.intino.alexandria.ingestion.SessionHandler;
import io.intino.alexandria.ingestion.SetSession;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.message.Message;
import io.intino.alexandria.terminal.Connector;
import io.intino.cesar.datahub.Datalake;
import io.intino.cesar.datahub.events.cesar.InfrastructureOperation;
import io.intino.cesar.datahub.events.cesar.ProcessOperation;
import io.intino.cesar.datahub.events.consul.process.ProcessLog;
import io.intino.cesar.datahub.events.consul.process.ProcessStatus;
import io.intino.cesar.datahub.events.consul.server.ServerBoot;
import io.intino.cesar.datahub.events.consul.server.ServerInfo;
import io.intino.cesar.datahub.events.consul.server.ServerLog;
import io.intino.cesar.datahub.events.consul.server.ServerStatus;
import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class CesarTerminal {
    private final Connector connector;
    private final Map<BiConsumer<?, String>, List<Consumer<Event>>> consumers = new HashMap();
    public static String[] subscriptionChannels = new String[0];
    private static final Object monitor = new Object();

    public CesarTerminal(Connector connector) {
        this.connector = connector;
    }

    public void publish(Object event, String split) {
        if (event instanceof InfrastructureOperation) {
            this.publish((InfrastructureOperation)event);
        }
        if (event instanceof ProcessOperation) {
            this.publish((ProcessOperation)event);
        }
    }

    public Datalake datalake(File directory) {
        return new Datalake(directory);
    }

    public BatchSession batch(File temporalStageDirectory) {
        return new BatchSession(temporalStageDirectory);
    }

    public BatchSession batch(File temporalStageDirectory, Config config) {
        return new BatchSession(temporalStageDirectory, config);
    }

    public void publish(SessionEvent session) {
        this.connector.sendEvent("Session", (Event)session);
    }

    public void subscribe(SessionEventConsumer onEventReceived) {
        this.consumers.put(onEventReceived, List.of(event -> onEventReceived.accept(new SessionEvent(event.toMessage()), "Session")));
        this.connector.attachListener("Session", this.consumers.get(onEventReceived).get(0));
    }

    public void publish(InfrastructureOperation infrastructureOperation) {
        this.connector.sendEvent("cesar.InfrastructureOperation", (Event)infrastructureOperation);
    }

    public void publish(ProcessOperation processOperation) {
        this.connector.sendEvent("cesar.ProcessOperation", (Event)processOperation);
    }

    public void subscribe(ConsulprocessProcessLogConsumer onEventReceived, String subscriberId) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ProcessLog(event), "consul.process.ProcessLog");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("consul.process.ProcessLog", subscriberId, this.consumers.get(onEventReceived).get(0));
    }

    public void subscribe(ConsulprocessProcessLogConsumer onEventReceived, String subscriberId, Predicate<Instant> filter) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ProcessLog(event), "consul.process.ProcessLog");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("consul.process.ProcessLog", subscriberId, this.consumers.get(onEventReceived).get(0), filter);
    }

    public void subscribe(ConsulprocessProcessLogConsumer onEventReceived) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ProcessLog(event), "consul.process.ProcessLog");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("consul.process.ProcessLog", this.consumers.get(onEventReceived).get(0));
    }

    public void unsubscribe(ConsulprocessProcessLogConsumer onEventReceived) {
        this.consumers.get(onEventReceived).forEach(c -> this.connector.detachListeners(c));
    }

    public void subscribe(ConsulprocessProcessStatusConsumer onEventReceived, String subscriberId) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ProcessStatus(event), "consul.process.ProcessStatus");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("consul.process.ProcessStatus", subscriberId, this.consumers.get(onEventReceived).get(0));
    }

    public void subscribe(ConsulprocessProcessStatusConsumer onEventReceived, String subscriberId, Predicate<Instant> filter) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ProcessStatus(event), "consul.process.ProcessStatus");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("consul.process.ProcessStatus", subscriberId, this.consumers.get(onEventReceived).get(0), filter);
    }

    public void subscribe(ConsulprocessProcessStatusConsumer onEventReceived) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ProcessStatus(event), "consul.process.ProcessStatus");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("consul.process.ProcessStatus", this.consumers.get(onEventReceived).get(0));
    }

    public void unsubscribe(ConsulprocessProcessStatusConsumer onEventReceived) {
        this.consumers.get(onEventReceived).forEach(c -> this.connector.detachListeners(c));
    }

    public void subscribe(ConsulserverServerBootConsumer onEventReceived, String subscriberId) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ServerBoot(event), "consul.server.ServerBoot");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("consul.server.ServerBoot", subscriberId, this.consumers.get(onEventReceived).get(0));
    }

    public void subscribe(ConsulserverServerBootConsumer onEventReceived, String subscriberId, Predicate<Instant> filter) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ServerBoot(event), "consul.server.ServerBoot");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("consul.server.ServerBoot", subscriberId, this.consumers.get(onEventReceived).get(0), filter);
    }

    public void subscribe(ConsulserverServerBootConsumer onEventReceived) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ServerBoot(event), "consul.server.ServerBoot");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("consul.server.ServerBoot", this.consumers.get(onEventReceived).get(0));
    }

    public void unsubscribe(ConsulserverServerBootConsumer onEventReceived) {
        this.consumers.get(onEventReceived).forEach(c -> this.connector.detachListeners(c));
    }

    public void subscribe(ConsulserverServerInfoConsumer onEventReceived, String subscriberId) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ServerInfo(event), "consul.server.ServerInfo");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("consul.server.ServerInfo", subscriberId, this.consumers.get(onEventReceived).get(0));
    }

    public void subscribe(ConsulserverServerInfoConsumer onEventReceived, String subscriberId, Predicate<Instant> filter) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ServerInfo(event), "consul.server.ServerInfo");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("consul.server.ServerInfo", subscriberId, this.consumers.get(onEventReceived).get(0), filter);
    }

    public void subscribe(ConsulserverServerInfoConsumer onEventReceived) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ServerInfo(event), "consul.server.ServerInfo");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("consul.server.ServerInfo", this.consumers.get(onEventReceived).get(0));
    }

    public void unsubscribe(ConsulserverServerInfoConsumer onEventReceived) {
        this.consumers.get(onEventReceived).forEach(c -> this.connector.detachListeners(c));
    }

    public void subscribe(ConsulserverServerLogConsumer onEventReceived, String subscriberId) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ServerLog(event), "consul.server.ServerLog");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("consul.server.ServerLog", subscriberId, this.consumers.get(onEventReceived).get(0));
    }

    public void subscribe(ConsulserverServerLogConsumer onEventReceived, String subscriberId, Predicate<Instant> filter) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ServerLog(event), "consul.server.ServerLog");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("consul.server.ServerLog", subscriberId, this.consumers.get(onEventReceived).get(0), filter);
    }

    public void subscribe(ConsulserverServerLogConsumer onEventReceived) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ServerLog(event), "consul.server.ServerLog");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("consul.server.ServerLog", this.consumers.get(onEventReceived).get(0));
    }

    public void unsubscribe(ConsulserverServerLogConsumer onEventReceived) {
        this.consumers.get(onEventReceived).forEach(c -> this.connector.detachListeners(c));
    }

    public void subscribe(ConsulserverServerStatusConsumer onEventReceived, String subscriberId) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ServerStatus(event), "consul.server.ServerStatus");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("consul.server.ServerStatus", subscriberId, this.consumers.get(onEventReceived).get(0));
    }

    public void subscribe(ConsulserverServerStatusConsumer onEventReceived, String subscriberId, Predicate<Instant> filter) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ServerStatus(event), "consul.server.ServerStatus");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("consul.server.ServerStatus", subscriberId, this.consumers.get(onEventReceived).get(0), filter);
    }

    public void subscribe(ConsulserverServerStatusConsumer onEventReceived) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ServerStatus(event), "consul.server.ServerStatus");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("consul.server.ServerStatus", this.consumers.get(onEventReceived).get(0));
    }

    public void unsubscribe(ConsulserverServerStatusConsumer onEventReceived) {
        this.consumers.get(onEventReceived).forEach(c -> this.connector.detachListeners(c));
    }

    public void subscribe(CesarInfrastructureOperationConsumer onEventReceived, String subscriberId) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new InfrastructureOperation(event), "cesar.InfrastructureOperation");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("cesar.InfrastructureOperation", subscriberId, this.consumers.get(onEventReceived).get(0));
    }

    public void subscribe(CesarInfrastructureOperationConsumer onEventReceived, String subscriberId, Predicate<Instant> filter) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new InfrastructureOperation(event), "cesar.InfrastructureOperation");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("cesar.InfrastructureOperation", subscriberId, this.consumers.get(onEventReceived).get(0), filter);
    }

    public void subscribe(CesarInfrastructureOperationConsumer onEventReceived) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new InfrastructureOperation(event), "cesar.InfrastructureOperation");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("cesar.InfrastructureOperation", this.consumers.get(onEventReceived).get(0));
    }

    public void unsubscribe(CesarInfrastructureOperationConsumer onEventReceived) {
        this.consumers.get(onEventReceived).forEach(c -> this.connector.detachListeners(c));
    }

    public void subscribe(CesarProcessOperationConsumer onEventReceived, String subscriberId) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ProcessOperation(event), "cesar.ProcessOperation");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("cesar.ProcessOperation", subscriberId, this.consumers.get(onEventReceived).get(0));
    }

    public void subscribe(CesarProcessOperationConsumer onEventReceived, String subscriberId, Predicate<Instant> filter) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ProcessOperation(event), "cesar.ProcessOperation");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("cesar.ProcessOperation", subscriberId, this.consumers.get(onEventReceived).get(0), filter);
    }

    public void subscribe(CesarProcessOperationConsumer onEventReceived) {
        this.consumers.put(onEventReceived, List.of(event -> {
            try {
                onEventReceived.accept(new ProcessOperation(event), "cesar.ProcessOperation");
            }
            catch (Throwable e) {
                Logger.error((Throwable)e);
            }
        }));
        this.connector.attachListener("cesar.ProcessOperation", this.consumers.get(onEventReceived).get(0));
    }

    public void unsubscribe(CesarProcessOperationConsumer onEventReceived) {
        this.consumers.get(onEventReceived).forEach(c -> this.connector.detachListeners(c));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void requestSeal() {
        Object object = monitor;
        synchronized (object) {
            this.connector.requestResponse("service.ness.seal", new Event(new Message("Seal")).ts(Instant.now()).toString(), s -> {
                Object object = monitor;
                synchronized (object) {
                    monitor.notify();
                }
            });
            try {
                monitor.wait(1800000L);
            }
            catch (InterruptedException e) {
                Logger.error((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Instant requestLastSeal() {
        AtomicReference<Instant> timestamp = new AtomicReference<Instant>(Instant.now());
        Object object = monitor;
        synchronized (object) {
            this.connector.requestResponse("service.ness.seal.last", new Event(new Message("LastSeal")).ts(Instant.now()).toString(), s -> {
                Object object = monitor;
                synchronized (object) {
                    if (s != null) {
                        timestamp.set(Instant.parse(s));
                    }
                    monitor.notify();
                }
            });
            try {
                monitor.wait(10000L);
            }
            catch (InterruptedException e) {
                Logger.error((Throwable)e);
            }
        }
        return timestamp.get();
    }

    public static interface ConsulserverServerInfoConsumer
    extends BiConsumer<ServerInfo, String> {
    }

    public static interface CesarInfrastructureOperationConsumer
    extends BiConsumer<InfrastructureOperation, String> {
    }

    public static interface ConsulserverServerLogConsumer
    extends BiConsumer<ServerLog, String> {
    }

    public static interface ConsulprocessProcessLogConsumer
    extends BiConsumer<ProcessLog, String> {
    }

    public static interface ConsulserverServerStatusConsumer
    extends BiConsumer<ServerStatus, String> {
    }

    public static interface ConsulserverServerBootConsumer
    extends BiConsumer<ServerBoot, String> {
    }

    public static interface ConsulprocessProcessStatusConsumer
    extends BiConsumer<ProcessStatus, String> {
    }

    public static interface CesarProcessOperationConsumer
    extends BiConsumer<ProcessOperation, String> {
    }

    public static interface SessionEventConsumer
    extends BiConsumer<SessionEvent, String> {
    }

    public static class Config {
        private int eventsBufferSize = 1000000;
        private int setsBufferSize = 1000000;
        private Scale scale = Scale.Day;

        public Config scale(Scale scale) {
            this.scale = scale;
            return this;
        }

        public Config eventsBufferSize(int eventsBufferSize) {
            this.eventsBufferSize = eventsBufferSize;
            return this;
        }

        public Config setsBufferSize(int setsBufferSize) {
            this.setsBufferSize = setsBufferSize;
            return this;
        }
    }

    public class BatchSession {
        private final File temporalStage;
        private final SessionHandler sessionHandler;
        private final EventSession eventSession;
        private final SetSession setSession;
        private final Scale scale;

        public BatchSession(File temporalStage) {
            this(temporalStage, new Config());
        }

        public BatchSession(File temporalStage, Config config) {
            this.temporalStage = temporalStage;
            this.scale = config.scale;
            this.sessionHandler = new SessionHandler(temporalStage);
            this.eventSession = this.sessionHandler.createEventSession(config.eventsBufferSize);
            this.setSession = this.sessionHandler.createSetSession(config.setsBufferSize);
        }

        public void feed(Event event, String split) {
            this.eventSession.put(this.tankOf(event, split), Timetag.of((Instant)event.ts(), (Scale)this.scale), new Event[]{event});
        }

        public void feed(Event event, String split, Scale scale) {
            this.eventSession.put(this.tankOf(event, split), Timetag.of((Instant)event.ts(), (Scale)scale), new Event[]{event});
        }

        public void feed(SessionEvent event) {
            this.eventSession.put("Session", Timetag.of((Instant)event.ts(), (Scale)Scale.Day), new Event[]{event});
        }

        public void flush() {
            this.eventSession.flush();
            this.setSession.flush();
        }

        public void push(File dataHubStage) {
            this.eventSession.close();
            this.setSession.close();
            this.sessionHandler.pushTo(dataHubStage);
        }

        public void push(String host, String user, String dataHubStageAbsolutePath) {
            this.eventSession.close();
            this.setSession.close();
            List<File> files = FS.allFilesIn((File)this.temporalStage, path -> path.getName().endsWith(".session")).collect(Collectors.toList());
            this.upload(files, host, user, dataHubStageAbsolutePath);
            this.temporalStage.renameTo(new File(this.temporalStage.getParentFile(), this.temporalStage.getName() + ".treated"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void seal() {
            Object object = monitor;
            synchronized (object) {
                CesarTerminal.this.connector.requestResponse("service.ness.seal", new Event(new Message("Seal").set("stage", this.temporalStage.getName())).ts(Instant.now()).toString(), s -> {
                    Object object = monitor;
                    synchronized (object) {
                        monitor.notify();
                    }
                });
                try {
                    monitor.wait();
                }
                catch (InterruptedException e) {
                    Logger.error((Throwable)e);
                }
            }
        }

        private void upload(List<File> sessions, String host, String user, String dataHubStageAbsolutePath) {
            try {
                String connectionChain = user + "@" + host + ":" + dataHubStageAbsolutePath;
                Logger.info((String)("Uploading sessions to " + connectionChain + "..."));
                for (File s : sessions) {
                    Process process = new ProcessBuilder("scp", s.getAbsolutePath(), connectionChain).inheritIO().start();
                    process.waitFor(1L, TimeUnit.HOURS);
                }
                Logger.info((String)"sessions uploaded");
            }
            catch (IOException | InterruptedException exception) {
                // empty catch block
            }
        }

        private String tankOf(Event event, String split) {
            if (event instanceof InfrastructureOperation) {
                return "cesar.InfrastructureOperation";
            }
            if (event instanceof ProcessOperation) {
                return "cesar.ProcessOperation";
            }
            return event.toMessage().type();
        }
    }
}

