package io.intino.cesar.datahub;

import io.intino.alexandria.Timetag;
import io.intino.alexandria.Scale;
import io.intino.alexandria.event.Event;
import io.intino.alexandria.logger.Logger;

import java.util.concurrent.atomic.AtomicReference;

import java.time.Instant;

import java.util.function.Consumer;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.io.File;

public class CesarTerminal {
	private final io.intino.alexandria.terminal.Connector connector;
	private final java.util.Map<java.util.function.BiConsumer<?, String>, List<java.util.function.Consumer<io.intino.alexandria.event.Event>>> consumers = new java.util.HashMap<>();

	public static String[] subscriptionChannels = new String[]{};

	public CesarTerminal(io.intino.alexandria.terminal.Connector connector) {
		this.connector = connector;
	}

	public void publish(Object event, String split) {
		if (event instanceof io.intino.cesar.datahub.events.cesar.InfrastructureOperation) publish((io.intino.cesar.datahub.events.cesar.InfrastructureOperation) event);
		if (event instanceof io.intino.cesar.datahub.events.cesar.ProcessOperation) publish((io.intino.cesar.datahub.events.cesar.ProcessOperation) event);
	}


	public Datalake datalake(java.io.File directory) {
		return new Datalake(directory);
	}

	public BatchSession batch(java.io.File temporalStageDirectory) {
		return new BatchSession(temporalStageDirectory);
	}

	public BatchSession batch(java.io.File temporalStageDirectory, Config config) {
		return new BatchSession(temporalStageDirectory, config);
	}


	public void publish(io.intino.alexandria.event.SessionEvent session) {
		connector.sendEvent(io.intino.alexandria.event.SessionEvent.PATH, session);
	}

	public void subscribe(SessionEventConsumer onEventReceived) {
		consumers.put(onEventReceived, List.of(event -> onEventReceived.accept(new io.intino.alexandria.event.SessionEvent(event.toMessage()), io.intino.alexandria.event.SessionEvent.PATH)));
		connector.attachListener(io.intino.alexandria.event.SessionEvent.PATH, consumers.get(onEventReceived).get(0));
	}

	public void publish(io.intino.cesar.datahub.events.cesar.InfrastructureOperation infrastructureOperation) {
		connector.sendEvent("cesar.InfrastructureOperation", infrastructureOperation);
	}

	public void publish(io.intino.cesar.datahub.events.cesar.ProcessOperation processOperation) {
		connector.sendEvent("cesar.ProcessOperation", processOperation);
	}

	public void subscribe(ConsulprocessProcessLogConsumer onEventReceived, String subscriberId) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cesar.datahub.events.consul.process.ProcessLog(event), "consul.process.ProcessLog");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("consul.process.ProcessLog", subscriberId, consumers.get(onEventReceived).get(0));
	}

	public void subscribe(ConsulprocessProcessLogConsumer onEventReceived, String subscriberId, java.util.function.Predicate<Instant> filter) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cesar.datahub.events.consul.process.ProcessLog(event), "consul.process.ProcessLog");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("consul.process.ProcessLog", subscriberId, consumers.get(onEventReceived).get(0), filter);
	}

	public void subscribe(ConsulprocessProcessLogConsumer onEventReceived) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cesar.datahub.events.consul.process.ProcessLog(event), "consul.process.ProcessLog");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("consul.process.ProcessLog", consumers.get(onEventReceived).get(0));
	}

	public void unsubscribe(ConsulprocessProcessLogConsumer onEventReceived) {
		consumers.get(onEventReceived).forEach(c -> connector.detachListeners(c));
	}

	public void subscribe(ConsulprocessProcessStatusConsumer onEventReceived, String subscriberId) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cesar.datahub.events.consul.process.ProcessStatus(event), "consul.process.ProcessStatus");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("consul.process.ProcessStatus", subscriberId, consumers.get(onEventReceived).get(0));
	}

	public void subscribe(ConsulprocessProcessStatusConsumer onEventReceived, String subscriberId, java.util.function.Predicate<Instant> filter) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cesar.datahub.events.consul.process.ProcessStatus(event), "consul.process.ProcessStatus");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("consul.process.ProcessStatus", subscriberId, consumers.get(onEventReceived).get(0), filter);
	}

	public void subscribe(ConsulprocessProcessStatusConsumer onEventReceived) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cesar.datahub.events.consul.process.ProcessStatus(event), "consul.process.ProcessStatus");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("consul.process.ProcessStatus", consumers.get(onEventReceived).get(0));
	}

	public void unsubscribe(ConsulprocessProcessStatusConsumer onEventReceived) {
		consumers.get(onEventReceived).forEach(c -> connector.detachListeners(c));
	}

	public void subscribe(ConsulserverServerBootConsumer onEventReceived, String subscriberId) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cesar.datahub.events.consul.server.ServerBoot(event), "consul.server.ServerBoot");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("consul.server.ServerBoot", subscriberId, consumers.get(onEventReceived).get(0));
	}

	public void subscribe(ConsulserverServerBootConsumer onEventReceived, String subscriberId, java.util.function.Predicate<Instant> filter) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cesar.datahub.events.consul.server.ServerBoot(event), "consul.server.ServerBoot");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("consul.server.ServerBoot", subscriberId, consumers.get(onEventReceived).get(0), filter);
	}

	public void subscribe(ConsulserverServerBootConsumer onEventReceived) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cesar.datahub.events.consul.server.ServerBoot(event), "consul.server.ServerBoot");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("consul.server.ServerBoot", consumers.get(onEventReceived).get(0));
	}

	public void unsubscribe(ConsulserverServerBootConsumer onEventReceived) {
		consumers.get(onEventReceived).forEach(c -> connector.detachListeners(c));
	}

	public void subscribe(ConsulserverServerInfoConsumer onEventReceived, String subscriberId) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cesar.datahub.events.consul.server.ServerInfo(event), "consul.server.ServerInfo");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("consul.server.ServerInfo", subscriberId, consumers.get(onEventReceived).get(0));
	}

	public void subscribe(ConsulserverServerInfoConsumer onEventReceived, String subscriberId, java.util.function.Predicate<Instant> filter) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cesar.datahub.events.consul.server.ServerInfo(event), "consul.server.ServerInfo");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("consul.server.ServerInfo", subscriberId, consumers.get(onEventReceived).get(0), filter);
	}

	public void subscribe(ConsulserverServerInfoConsumer onEventReceived) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cesar.datahub.events.consul.server.ServerInfo(event), "consul.server.ServerInfo");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("consul.server.ServerInfo", consumers.get(onEventReceived).get(0));
	}

	public void unsubscribe(ConsulserverServerInfoConsumer onEventReceived) {
		consumers.get(onEventReceived).forEach(c -> connector.detachListeners(c));
	}

	public void subscribe(ConsulserverServerLogConsumer onEventReceived, String subscriberId) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cesar.datahub.events.consul.server.ServerLog(event), "consul.server.ServerLog");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("consul.server.ServerLog", subscriberId, consumers.get(onEventReceived).get(0));
	}

	public void subscribe(ConsulserverServerLogConsumer onEventReceived, String subscriberId, java.util.function.Predicate<Instant> filter) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cesar.datahub.events.consul.server.ServerLog(event), "consul.server.ServerLog");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("consul.server.ServerLog", subscriberId, consumers.get(onEventReceived).get(0), filter);
	}

	public void subscribe(ConsulserverServerLogConsumer onEventReceived) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cesar.datahub.events.consul.server.ServerLog(event), "consul.server.ServerLog");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("consul.server.ServerLog", consumers.get(onEventReceived).get(0));
	}

	public void unsubscribe(ConsulserverServerLogConsumer onEventReceived) {
		consumers.get(onEventReceived).forEach(c -> connector.detachListeners(c));
	}

	public void subscribe(ConsulserverServerStatusConsumer onEventReceived, String subscriberId) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cesar.datahub.events.consul.server.ServerStatus(event), "consul.server.ServerStatus");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("consul.server.ServerStatus", subscriberId, consumers.get(onEventReceived).get(0));
	}

	public void subscribe(ConsulserverServerStatusConsumer onEventReceived, String subscriberId, java.util.function.Predicate<Instant> filter) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cesar.datahub.events.consul.server.ServerStatus(event), "consul.server.ServerStatus");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("consul.server.ServerStatus", subscriberId, consumers.get(onEventReceived).get(0), filter);
	}

	public void subscribe(ConsulserverServerStatusConsumer onEventReceived) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cesar.datahub.events.consul.server.ServerStatus(event), "consul.server.ServerStatus");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("consul.server.ServerStatus", consumers.get(onEventReceived).get(0));
	}

	public void unsubscribe(ConsulserverServerStatusConsumer onEventReceived) {
		consumers.get(onEventReceived).forEach(c -> connector.detachListeners(c));
	}

	public void subscribe(CesarInfrastructureOperationConsumer onEventReceived, String subscriberId) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cesar.datahub.events.cesar.InfrastructureOperation(event), "cesar.InfrastructureOperation");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("cesar.InfrastructureOperation", subscriberId, consumers.get(onEventReceived).get(0));
	}

	public void subscribe(CesarInfrastructureOperationConsumer onEventReceived, String subscriberId, java.util.function.Predicate<Instant> filter) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cesar.datahub.events.cesar.InfrastructureOperation(event), "cesar.InfrastructureOperation");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("cesar.InfrastructureOperation", subscriberId, consumers.get(onEventReceived).get(0), filter);
	}

	public void subscribe(CesarInfrastructureOperationConsumer onEventReceived) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cesar.datahub.events.cesar.InfrastructureOperation(event), "cesar.InfrastructureOperation");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("cesar.InfrastructureOperation", consumers.get(onEventReceived).get(0));
	}

	public void unsubscribe(CesarInfrastructureOperationConsumer onEventReceived) {
		consumers.get(onEventReceived).forEach(c -> connector.detachListeners(c));
	}

	public void subscribe(CesarProcessOperationConsumer onEventReceived, String subscriberId) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cesar.datahub.events.cesar.ProcessOperation(event), "cesar.ProcessOperation");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("cesar.ProcessOperation", subscriberId, consumers.get(onEventReceived).get(0));
	}

	public void subscribe(CesarProcessOperationConsumer onEventReceived, String subscriberId, java.util.function.Predicate<Instant> filter) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cesar.datahub.events.cesar.ProcessOperation(event), "cesar.ProcessOperation");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("cesar.ProcessOperation", subscriberId, consumers.get(onEventReceived).get(0), filter);
	}

	public void subscribe(CesarProcessOperationConsumer onEventReceived) {
		consumers.put(onEventReceived, List.of(event -> { try { onEventReceived.accept(new io.intino.cesar.datahub.events.cesar.ProcessOperation(event), "cesar.ProcessOperation");} catch(Throwable e) { Logger.error(e); }}));
		connector.attachListener("cesar.ProcessOperation", consumers.get(onEventReceived).get(0));
	}

	public void unsubscribe(CesarProcessOperationConsumer onEventReceived) {
		consumers.get(onEventReceived).forEach(c -> connector.detachListeners(c));
	}

	private static final Object monitor = new Object();

	public synchronized void requestSeal() {
		synchronized(monitor) {
			connector.requestResponse("service.ness.seal", new Event(new io.intino.alexandria.message.Message("Seal")).ts(java.time.Instant.now()).toString(), s -> {
				synchronized(monitor) {monitor.notify();}
			});
			try {
				monitor.wait(1000 * 60 * 30);
			} catch (InterruptedException e) {
				io.intino.alexandria.logger.Logger.error(e);
			}
		}
	}

	public synchronized Instant requestLastSeal() {
		final AtomicReference<Instant> timestamp = new AtomicReference<>(Instant.now());
		synchronized(monitor) {
			connector.requestResponse("service.ness.seal.last", new Event(new io.intino.alexandria.message.Message("LastSeal")).ts(java.time.Instant.now()).toString(), s -> {
				synchronized(monitor) {
					if (s != null) timestamp.set(Instant.parse(s));
					monitor.notify();
				}
			});
			try {
				monitor.wait(1000 * 10);
			} catch (InterruptedException e) {
				io.intino.alexandria.logger.Logger.error(e);
			}
		}
		return timestamp.get();
	}

	public class BatchSession {
		private final java.io.File temporalStage;
		private final io.intino.alexandria.ingestion.SessionHandler sessionHandler;
		private final io.intino.alexandria.ingestion.EventSession eventSession;
		private final io.intino.alexandria.ingestion.SetSession setSession;
		private final Scale scale;

		public BatchSession(java.io.File temporalStage) {
			this(temporalStage, new Config());
		}

		public BatchSession(java.io.File temporalStage, Config config) {
			this.temporalStage = temporalStage;
			this.scale = config.scale;
			this.sessionHandler = new io.intino.alexandria.ingestion.SessionHandler(temporalStage);
			this.eventSession = sessionHandler.createEventSession(config.eventsBufferSize);
			this.setSession = sessionHandler.createSetSession(config.setsBufferSize);
		}

		public void feed(Event event, String split) {
            eventSession.put(tankOf(event, split), Timetag.of(event.ts(), this.scale), event);
		}

		public void feed(Event event, String split, Scale scale) {
			eventSession.put(tankOf(event, split), Timetag.of(event.ts(), scale), event);
		}

		public void feed(io.intino.alexandria.event.SessionEvent event) {
			eventSession.put(io.intino.alexandria.event.SessionEvent.PATH, Timetag.of(event.ts(), Scale.Day), event);
		}

		public void flush() {
			eventSession.flush();
			setSession.flush();
		}

		public void push(File dataHubStage) {
			eventSession.close();
			setSession.close();
			sessionHandler.pushTo(dataHubStage);
			//connector.sendEvent("service.ness.push", new Event(new io.intino.alexandria.message.Message("Push").set("stage", temporalStage.getName())));
		}

		public void push(String host, String user, String dataHubStageAbsolutePath) {
			eventSession.close();
			setSession.close();
			List<File> files = io.intino.alexandria.ingestion.FS.allFilesIn(temporalStage, path -> path.getName().endsWith(io.intino.alexandria.Session.SessionExtension)).collect(Collectors.toList());
			upload(files, host, user, dataHubStageAbsolutePath);
			temporalStage.renameTo(new File(temporalStage.getParentFile(), temporalStage.getName() + ".treated"));
		}

		public synchronized void seal() {
			synchronized(monitor) {
				connector.requestResponse("service.ness.seal", new Event(new io.intino.alexandria.message.Message("Seal").set("stage", temporalStage.getName())).ts(java.time.Instant.now()).toString(), s -> {
						synchronized(monitor) {
							monitor.notify();
						}
					}
				);
				try {
					monitor.wait();
				} catch (InterruptedException e) {
					io.intino.alexandria.logger.Logger.error(e);
				}
			}
        }

        private void upload(List<File> sessions, String host, String user, String dataHubStageAbsolutePath) {
			try {
				String connectionChain = user + "@" + host + ":" + dataHubStageAbsolutePath;
				Logger.info("Uploading sessions to " + connectionChain + "...");
				for (File s : sessions) {
					Process process = new ProcessBuilder("scp", s.getAbsolutePath(), connectionChain)
							.inheritIO()
							.start();
					process.waitFor(1, java.util.concurrent.TimeUnit.HOURS);
				}
				Logger.info("sessions uploaded");
			} catch (java.io.IOException | InterruptedException ignored) {
			}

		}

        private String tankOf(Event event, String split) {
        	if (event instanceof io.intino.cesar.datahub.events.cesar.InfrastructureOperation) return "cesar.InfrastructureOperation";
        	if (event instanceof io.intino.cesar.datahub.events.cesar.ProcessOperation) return "cesar.ProcessOperation";
        	return event.toMessage().type();
        }
	}

	public static class Config {
		private int eventsBufferSize = 1_000_000;
		private int setsBufferSize = 1_000_000;
		private Scale scale = Scale.Day;

		public Config scale(Scale scale) {
			this.scale = scale;
			return this;
		}

		public Config eventsBufferSize(int eventsBufferSize) {
			this.eventsBufferSize = eventsBufferSize;
			return this;
		}

		public Config setsBufferSize(int setsBufferSize) {
			this.setsBufferSize = setsBufferSize;
			return this;
		}
	}

	public interface SessionEventConsumer extends java.util.function.BiConsumer<io.intino.alexandria.event.SessionEvent, String> {
	}

	public interface CesarProcessOperationConsumer extends java.util.function.BiConsumer<io.intino.cesar.datahub.events.cesar.ProcessOperation, String> {
	}

	public interface ConsulprocessProcessStatusConsumer extends java.util.function.BiConsumer<io.intino.cesar.datahub.events.consul.process.ProcessStatus, String> {
	}

	public interface ConsulserverServerBootConsumer extends java.util.function.BiConsumer<io.intino.cesar.datahub.events.consul.server.ServerBoot, String> {
	}

	public interface ConsulserverServerStatusConsumer extends java.util.function.BiConsumer<io.intino.cesar.datahub.events.consul.server.ServerStatus, String> {
	}

	public interface ConsulprocessProcessLogConsumer extends java.util.function.BiConsumer<io.intino.cesar.datahub.events.consul.process.ProcessLog, String> {
	}

	public interface ConsulserverServerLogConsumer extends java.util.function.BiConsumer<io.intino.cesar.datahub.events.consul.server.ServerLog, String> {
	}

	public interface CesarInfrastructureOperationConsumer extends java.util.function.BiConsumer<io.intino.cesar.datahub.events.cesar.InfrastructureOperation, String> {
	}

	public interface ConsulserverServerInfoConsumer extends java.util.function.BiConsumer<io.intino.cesar.datahub.events.consul.server.ServerInfo, String> {
	}
}