/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.datahub;

import io.intino.alexandria.Scale;
import io.intino.alexandria.Timetag;
import io.intino.alexandria.event.Event;
import io.intino.alexandria.event.SessionEvent;
import io.intino.alexandria.ingestion.EventSession;
import io.intino.alexandria.ingestion.SessionHandler;
import io.intino.alexandria.ingestion.SetSession;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.message.Message;
import io.intino.alexandria.terminal.Connector;
import io.intino.cesar.datahub.events.DeviceInfo;
import io.intino.cesar.datahub.events.cesar.InfrastructureOperation;
import io.intino.cesar.datahub.events.cesar.ProcessOperation;
import io.intino.cesar.datahub.events.consul.device.DeviceBoot;
import io.intino.cesar.datahub.events.consul.device.DeviceCrash;
import io.intino.cesar.datahub.events.consul.device.DeviceStatus;
import io.intino.cesar.datahub.events.consul.device.DeviceUpgrade;
import io.intino.cesar.datahub.events.consul.process.ProcessLog;
import io.intino.cesar.datahub.events.consul.process.ProcessStatus;
import io.intino.cesar.datahub.events.consul.server.ServerBoot;
import io.intino.cesar.datahub.events.consul.server.ServerInfo;
import io.intino.cesar.datahub.events.consul.server.ServerLog;
import io.intino.cesar.datahub.events.consul.server.ServerStatus;
import java.io.File;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

public class CesarTerminal {
    private static final Scale scale = Scale.Day;
    private final Connector connector;
    private Map<Consumer<?>, Consumer<Event>> consumers = new HashMap();
    public static String[] subscriptionChannels = new String[0];
    private static final Object monitor = new Object();

    public CesarTerminal(Connector connector) {
        this.connector = connector;
    }

    public void publish(Object event, String split) {
        if (event instanceof InfrastructureOperation) {
            this.publish((InfrastructureOperation)event);
        }
        if (event instanceof ProcessOperation) {
            this.publish((ProcessOperation)event);
        }
    }

    public BatchSession batch(File dataHubStageDirectory, File temporalStageDirectory) {
        return new BatchSession(dataHubStageDirectory, temporalStageDirectory);
    }

    public BatchSession batch(File dataHubStageDirectory, File temporalStageDirectory, Config config) {
        return new BatchSession(dataHubStageDirectory, temporalStageDirectory, config);
    }

    public void publish(SessionEvent session) {
        this.connector.sendEvent("Session", (Event)session);
    }

    public void subscribe(SessionEventConsumer onEventReceived) {
        this.consumers.put(onEventReceived, event -> onEventReceived.accept(new SessionEvent(event.toMessage())));
        this.connector.attachListener("Session", this.consumers.get(onEventReceived));
    }

    public void publish(InfrastructureOperation infrastructureOperation) {
        this.connector.sendEvent("cesar.InfrastructureOperation", (Event)infrastructureOperation);
    }

    public void publish(ProcessOperation processOperation) {
        this.connector.sendEvent("cesar.ProcessOperation", (Event)processOperation);
    }

    public void subscribe(ConsulprocessProcessLogConsumer onEventReceived, String subscriberId) {
        this.consumers.put(onEventReceived, event -> onEventReceived.accept(new ProcessLog(event)));
        this.connector.attachListener("consul.process.ProcessLog", subscriberId, this.consumers.get(onEventReceived));
    }

    public void subscribe(ConsulprocessProcessLogConsumer onEventReceived) {
        this.consumers.put(onEventReceived, event -> onEventReceived.accept(new ProcessLog(event)));
        this.connector.attachListener("consul.process.ProcessLog", this.consumers.get(onEventReceived));
    }

    public void unsubscribe(ConsulprocessProcessLogConsumer onEventReceived) {
        this.connector.detachListeners(this.consumers.get(onEventReceived));
    }

    public void subscribe(ConsulprocessProcessStatusConsumer onEventReceived, String subscriberId) {
        this.consumers.put(onEventReceived, event -> onEventReceived.accept(new ProcessStatus(event)));
        this.connector.attachListener("consul.process.ProcessStatus", subscriberId, this.consumers.get(onEventReceived));
    }

    public void subscribe(ConsulprocessProcessStatusConsumer onEventReceived) {
        this.consumers.put(onEventReceived, event -> onEventReceived.accept(new ProcessStatus(event)));
        this.connector.attachListener("consul.process.ProcessStatus", this.consumers.get(onEventReceived));
    }

    public void unsubscribe(ConsulprocessProcessStatusConsumer onEventReceived) {
        this.connector.detachListeners(this.consumers.get(onEventReceived));
    }

    public void subscribe(ConsulserverServerBootConsumer onEventReceived, String subscriberId) {
        this.consumers.put(onEventReceived, event -> onEventReceived.accept(new ServerBoot(event)));
        this.connector.attachListener("consul.server.ServerBoot", subscriberId, this.consumers.get(onEventReceived));
    }

    public void subscribe(ConsulserverServerBootConsumer onEventReceived) {
        this.consumers.put(onEventReceived, event -> onEventReceived.accept(new ServerBoot(event)));
        this.connector.attachListener("consul.server.ServerBoot", this.consumers.get(onEventReceived));
    }

    public void unsubscribe(ConsulserverServerBootConsumer onEventReceived) {
        this.connector.detachListeners(this.consumers.get(onEventReceived));
    }

    public void subscribe(ConsulserverServerInfoConsumer onEventReceived, String subscriberId) {
        this.consumers.put(onEventReceived, event -> onEventReceived.accept(new ServerInfo(event)));
        this.connector.attachListener("consul.server.ServerInfo", subscriberId, this.consumers.get(onEventReceived));
    }

    public void subscribe(ConsulserverServerInfoConsumer onEventReceived) {
        this.consumers.put(onEventReceived, event -> onEventReceived.accept(new ServerInfo(event)));
        this.connector.attachListener("consul.server.ServerInfo", this.consumers.get(onEventReceived));
    }

    public void unsubscribe(ConsulserverServerInfoConsumer onEventReceived) {
        this.connector.detachListeners(this.consumers.get(onEventReceived));
    }

    public void subscribe(ConsulserverServerLogConsumer onEventReceived, String subscriberId) {
        this.consumers.put(onEventReceived, event -> onEventReceived.accept(new ServerLog(event)));
        this.connector.attachListener("consul.server.ServerLog", subscriberId, this.consumers.get(onEventReceived));
    }

    public void subscribe(ConsulserverServerLogConsumer onEventReceived) {
        this.consumers.put(onEventReceived, event -> onEventReceived.accept(new ServerLog(event)));
        this.connector.attachListener("consul.server.ServerLog", this.consumers.get(onEventReceived));
    }

    public void unsubscribe(ConsulserverServerLogConsumer onEventReceived) {
        this.connector.detachListeners(this.consumers.get(onEventReceived));
    }

    public void subscribe(ConsulserverServerStatusConsumer onEventReceived, String subscriberId) {
        this.consumers.put(onEventReceived, event -> onEventReceived.accept(new ServerStatus(event)));
        this.connector.attachListener("consul.server.ServerStatus", subscriberId, this.consumers.get(onEventReceived));
    }

    public void subscribe(ConsulserverServerStatusConsumer onEventReceived) {
        this.consumers.put(onEventReceived, event -> onEventReceived.accept(new ServerStatus(event)));
        this.connector.attachListener("consul.server.ServerStatus", this.consumers.get(onEventReceived));
    }

    public void unsubscribe(ConsulserverServerStatusConsumer onEventReceived) {
        this.connector.detachListeners(this.consumers.get(onEventReceived));
    }

    public void subscribe(ConsuldeviceDeviceBootConsumer onEventReceived, String subscriberId) {
        this.consumers.put(onEventReceived, event -> onEventReceived.accept(new DeviceBoot(event)));
        this.connector.attachListener("consul.device.DeviceBoot", subscriberId, this.consumers.get(onEventReceived));
    }

    public void subscribe(ConsuldeviceDeviceBootConsumer onEventReceived) {
        this.consumers.put(onEventReceived, event -> onEventReceived.accept(new DeviceBoot(event)));
        this.connector.attachListener("consul.device.DeviceBoot", this.consumers.get(onEventReceived));
    }

    public void unsubscribe(ConsuldeviceDeviceBootConsumer onEventReceived) {
        this.connector.detachListeners(this.consumers.get(onEventReceived));
    }

    public void subscribe(ConsuldeviceDeviceCrashConsumer onEventReceived, String subscriberId) {
        this.consumers.put(onEventReceived, event -> onEventReceived.accept(new DeviceCrash(event)));
        this.connector.attachListener("consul.device.DeviceCrash", subscriberId, this.consumers.get(onEventReceived));
    }

    public void subscribe(ConsuldeviceDeviceCrashConsumer onEventReceived) {
        this.consumers.put(onEventReceived, event -> onEventReceived.accept(new DeviceCrash(event)));
        this.connector.attachListener("consul.device.DeviceCrash", this.consumers.get(onEventReceived));
    }

    public void unsubscribe(ConsuldeviceDeviceCrashConsumer onEventReceived) {
        this.connector.detachListeners(this.consumers.get(onEventReceived));
    }

    public void subscribe(ConsuldeviceDeviceStatusConsumer onEventReceived, String subscriberId) {
        this.consumers.put(onEventReceived, event -> onEventReceived.accept(new DeviceStatus(event)));
        this.connector.attachListener("consul.device.DeviceStatus", subscriberId, this.consumers.get(onEventReceived));
    }

    public void subscribe(ConsuldeviceDeviceStatusConsumer onEventReceived) {
        this.consumers.put(onEventReceived, event -> onEventReceived.accept(new DeviceStatus(event)));
        this.connector.attachListener("consul.device.DeviceStatus", this.consumers.get(onEventReceived));
    }

    public void unsubscribe(ConsuldeviceDeviceStatusConsumer onEventReceived) {
        this.connector.detachListeners(this.consumers.get(onEventReceived));
    }

    public void subscribe(ConsuldeviceDeviceUpgradeConsumer onEventReceived, String subscriberId) {
        this.consumers.put(onEventReceived, event -> onEventReceived.accept(new DeviceUpgrade(event)));
        this.connector.attachListener("consul.device.DeviceUpgrade", subscriberId, this.consumers.get(onEventReceived));
    }

    public void subscribe(ConsuldeviceDeviceUpgradeConsumer onEventReceived) {
        this.consumers.put(onEventReceived, event -> onEventReceived.accept(new DeviceUpgrade(event)));
        this.connector.attachListener("consul.device.DeviceUpgrade", this.consumers.get(onEventReceived));
    }

    public void unsubscribe(ConsuldeviceDeviceUpgradeConsumer onEventReceived) {
        this.connector.detachListeners(this.consumers.get(onEventReceived));
    }

    public void subscribe(CesarInfrastructureOperationConsumer onEventReceived, String subscriberId) {
        this.consumers.put(onEventReceived, event -> onEventReceived.accept(new InfrastructureOperation(event)));
        this.connector.attachListener("cesar.InfrastructureOperation", subscriberId, this.consumers.get(onEventReceived));
    }

    public void subscribe(CesarInfrastructureOperationConsumer onEventReceived) {
        this.consumers.put(onEventReceived, event -> onEventReceived.accept(new InfrastructureOperation(event)));
        this.connector.attachListener("cesar.InfrastructureOperation", this.consumers.get(onEventReceived));
    }

    public void unsubscribe(CesarInfrastructureOperationConsumer onEventReceived) {
        this.connector.detachListeners(this.consumers.get(onEventReceived));
    }

    public void subscribe(CesarProcessOperationConsumer onEventReceived, String subscriberId) {
        this.consumers.put(onEventReceived, event -> onEventReceived.accept(new ProcessOperation(event)));
        this.connector.attachListener("cesar.ProcessOperation", subscriberId, this.consumers.get(onEventReceived));
    }

    public void subscribe(CesarProcessOperationConsumer onEventReceived) {
        this.consumers.put(onEventReceived, event -> onEventReceived.accept(new ProcessOperation(event)));
        this.connector.attachListener("cesar.ProcessOperation", this.consumers.get(onEventReceived));
    }

    public void unsubscribe(CesarProcessOperationConsumer onEventReceived) {
        this.connector.detachListeners(this.consumers.get(onEventReceived));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void requestSeal() {
        Object object = monitor;
        synchronized (object) {
            this.connector.requestResponse("service.ness.seal", new Event(new Message("Seal")).ts(Instant.now()).toString(), s -> {
                Object object = monitor;
                synchronized (object) {
                    monitor.notify();
                }
            });
            try {
                monitor.wait(1800000L);
            }
            catch (InterruptedException e) {
                Logger.error((Throwable)e);
            }
        }
    }

    public static interface ConsuldeviceDeviceCrashConsumer
    extends Consumer<DeviceCrash> {
    }

    public static interface CesarInfrastructureOperationConsumer
    extends Consumer<InfrastructureOperation> {
    }

    public static interface ConsulprocessProcessLogConsumer
    extends Consumer<ProcessLog> {
    }

    public static interface CesarProcessOperationConsumer
    extends Consumer<ProcessOperation> {
    }

    public static interface ConsulserverServerBootConsumer
    extends Consumer<ServerBoot> {
    }

    public static interface ConsuldeviceDeviceBootConsumer
    extends Consumer<DeviceBoot> {
    }

    public static interface ConsuldeviceDeviceStatusConsumer
    extends Consumer<DeviceStatus> {
    }

    public static interface ConsuldeviceDeviceUpgradeConsumer
    extends Consumer<DeviceUpgrade> {
    }

    public static interface ConsulserverServerStatusConsumer
    extends Consumer<ServerStatus> {
    }

    public static interface ConsulprocessProcessStatusConsumer
    extends Consumer<ProcessStatus> {
    }

    public static interface ConsulserverServerLogConsumer
    extends Consumer<ServerLog> {
    }

    public static interface DeviceInfoConsumer
    extends Consumer<DeviceInfo> {
    }

    public static interface ConsulserverServerInfoConsumer
    extends Consumer<ServerInfo> {
    }

    public static interface SessionEventConsumer
    extends Consumer<SessionEvent> {
    }

    public static class Config {
        private int eventsBufferSise = 1000000;
        private int setsBufferSise = 1000000;

        public Config eventsBufferSise(int eventsBufferSise) {
            this.eventsBufferSise = eventsBufferSise;
            return this;
        }

        public Config setsBufferSise(int setsBufferSise) {
            this.setsBufferSise = setsBufferSise;
            return this;
        }
    }

    public class BatchSession {
        private final File dataHubStage;
        private final File temporalStage;
        private final SessionHandler sessionHandler;
        private final EventSession eventSession;
        private final SetSession setSession;

        public BatchSession(File dataHubStage, File temporalStage) {
            this(dataHubStage, temporalStage, new Config());
        }

        public BatchSession(File dataHubStage, File temporalStage, Config config) {
            this.dataHubStage = dataHubStage;
            this.temporalStage = temporalStage;
            this.sessionHandler = new SessionHandler(temporalStage);
            this.eventSession = this.sessionHandler.createEventSession();
            this.setSession = this.sessionHandler.createSetSession(config.setsBufferSise);
        }

        public void feed(Event event, String split) {
            this.eventSession.put(this.tankOf(event, split), Timetag.of((Instant)event.ts(), (Scale)scale), new Event[]{event});
        }

        public void feed(SessionEvent event) {
            this.eventSession.put("Session", Timetag.of((Instant)event.ts(), (Scale)Scale.Day), new Event[]{event});
        }

        public void flush() {
            this.eventSession.flush();
            this.setSession.flush();
        }

        public void push() {
            this.eventSession.close();
            this.setSession.close();
            this.sessionHandler.pushTo(this.dataHubStage);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void seal() {
            Object object = monitor;
            synchronized (object) {
                CesarTerminal.this.connector.requestResponse("service.ness.seal", new Event(new Message("Seal").set("stage", this.temporalStage.getName())).ts(Instant.now()).toString(), s -> {
                    Object object = monitor;
                    synchronized (object) {
                        monitor.notify();
                    }
                });
                try {
                    monitor.wait();
                }
                catch (InterruptedException e) {
                    Logger.error((Throwable)e);
                }
            }
        }

        private String tankOf(Event event, String split) {
            if (event instanceof InfrastructureOperation) {
                return "cesar.InfrastructureOperation";
            }
            if (event instanceof ProcessOperation) {
                return "cesar.ProcessOperation";
            }
            return event.toMessage().type();
        }
    }
}

