/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.chatconnector;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;

public class Configuration {
    private final Map<String, String> args;
    private File home;

    public Configuration(String[] args) {
        this.args = this.argsToMap(args);
        if (this.home == null) {
            this.home = this.args.get("home") != null ? new File(this.args.get("home")) : new File("./home");
        }
    }

    public String chatUrl() {
        return this.get("chat_url");
    }

    public String botUser() {
        return this.get("bot_user");
    }

    public String botPassword() {
        return this.get("bot_password");
    }

    public File projectsFile() {
        return new File(this.get("projects_file"));
    }

    public Object attachmentsDirectory() {
        return new File(this.get("attachments_directory"));
    }

    public File usersFile() {
        return new File(this.get("users_file"));
    }

    private String get(String key) {
        return this.args.get(key);
    }

    private Map<String, String> argsToMap(String[] args) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (String arg : args) {
            if (!arg.contains("=")) continue;
            String key = arg.substring(0, arg.indexOf("="));
            String value = arg.substring(arg.indexOf("=") + 1);
            map.put(key, value);
        }
        return map;
    }
}

