/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.chatconnector;

import com.github.baloise.rocketchatrestclient.RocketChatClient;
import com.rocketchat.common.data.model.ErrorObject;
import com.rocketchat.common.data.model.Room;
import com.rocketchat.common.data.model.UserObject;
import com.rocketchat.common.listener.ConnectListener;
import com.rocketchat.common.listener.SubscribeListener;
import com.rocketchat.common.network.ReconnectionStrategy;
import com.rocketchat.core.RocketChatAPI;
import com.rocketchat.core.callback.FileListener;
import com.rocketchat.core.callback.LoginListener;
import com.rocketchat.core.factory.ChatRoomFactory;
import com.rocketchat.core.model.FileObject;
import com.rocketchat.core.model.RocketChatMessage;
import com.rocketchat.core.model.TokenObject;
import io.intino.alexandria.Json;
import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.exceptions.Unauthorized;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.restaccessor.RestQueryBuilder;
import io.intino.cesar.chatconnector.BotResponse;
import io.intino.cesar.chatconnector.Configuration;
import io.intino.cesar.chatconnector.User;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class ChatBridge
implements ConnectListener,
LoginListener {
    private final Configuration conf;
    private final Set<String> subscribedRooms = new HashSet<String>();
    private final Map<String, User> users;
    private final Map<String, String> userTimeZones;
    private final Map<String, URL> projects;
    private RocketChatAPI client;
    private String userId;

    public ChatBridge(Configuration conf) {
        this.conf = conf;
        this.userTimeZones = new HashMap<String, String>();
        this.users = this.loadUsers();
        this.projects = this.loadProjects();
    }

    public void start() {
        this.client = new RocketChatAPI(this.conf.chatUrl());
        this.client.setReconnectionStrategy(new ReconnectionStrategy(20, 2000));
        this.client.connect(this);
    }

    @Override
    public void onConnect(String sessionID) {
        this.client.login(this.conf.botUser(), this.conf.botPassword(), this);
        this.client.setStatus(UserObject.Status.ONLINE, (aBoolean, errorObject) -> System.out.println(errorObject.getError()));
    }

    @Override
    public void onLogin(TokenObject token, ErrorObject error) {
        Logger.info((String)(error == null ? "Cesar connected successfully to rocketChat" : "Got error " + error.getMessage()));
        this.client.setStatus(UserObject.Status.ONLINE, (aBoolean, errorObject) -> System.out.println(errorObject.getError()));
        this.userId = token.getUserId();
        this.reloadSubscriptions();
    }

    private void reloadSubscriptions() {
        this.client.getRooms((rooms, e) -> {
            ChatRoomFactory factory = this.client.getChatRoomFactory();
            rooms.stream().map(ChatRoom::new).filter(r -> !this.isPublic((ChatRoom)r)).forEach(factory::addChatRoom);
            factory.getChatRooms().forEach(r -> {
                if (!this.subscribedRooms.add(r.getRoomData().getRoomId())) {
                    return;
                }
                r.subscribeRoomMessageEvent(this.emptySubscriber(), (roomId, message) -> new Thread(() -> {
                    if (message.getSender().getUserId().equals(this.userId)) {
                        return;
                    }
                    this.processMessage(factory.getChatRoomById(roomId), message);
                }).start());
            });
        });
    }

    private boolean isPublic(ChatRoom r) {
        return r.getRoomName().equalsIgnoreCase("GENERAL") || !r.type().equals((Object)ChatRoom.Type.ONE_TO_ONE);
    }

    private void processMessage(RocketChatAPI.ChatRoom chatRoom, RocketChatMessage message) {
        String userId = message.getSender().getUserId();
        String content = message.getMessage();
        if (this.isLogged(userId)) {
            if (this.isProjectSelect(content)) {
                this.selectProject(chatRoom, userId, content.replace("project ", ""));
            } else if (this.isProjects(content)) {
                chatRoom.sendMessage(String.join((CharSequence)"\n", this.projects.keySet()));
            } else if (this.users.get(userId).project() != null) {
                this.requestResponse(chatRoom, userId, content);
            } else {
                chatRoom.sendMessage("Please select a project with command `project *project*`. List projects with `projects`");
            }
        } else if (this.isLogin(content)) {
            this.tryLogIn(chatRoom, userId, message);
        } else {
            chatRoom.sendMessage("You are not logged, use command `login *user*::*password*`");
        }
    }

    private boolean isLogged(String userId) {
        return this.users.containsKey(userId);
    }

    private boolean isProjects(String content) {
        return content.equalsIgnoreCase("projects");
    }

    private boolean isProjectSelect(String message) {
        return message.toLowerCase().startsWith("project ");
    }

    private boolean isLogin(String message) {
        return message.toLowerCase().startsWith("login ");
    }

    private void selectProject(RocketChatAPI.ChatRoom chatRoom, String userId, String project) {
        User user = this.users.get(userId);
        if (!this.projects.containsKey(project)) {
            chatRoom.sendMessage("Project not found");
        } else {
            user.project(project);
            this.saveUsers();
            chatRoom.sendMessage("Project now is *" + project + "*");
        }
    }

    private void requestResponse(RocketChatAPI.ChatRoom chatRoom, String userId, String messageContent) {
        try {
            String content = new RestQueryBuilder(this.projects.get(this.users.get(userId).project())).bearerAuth(this.users.get(userId).token()).queryParameter("query", messageContent).queryParameter("timeZone", this.timeZone(userId)).post("bot").content();
            BotResponse botResponse = Json.fromString(content, BotResponse.class);
            if (botResponse.type().equals((Object)BotResponse.Type.text)) {
                String raw = botResponse.raw();
                List<String> lines = Arrays.asList(raw.split("\n"));
                if (lines.size() > 20) {
                    for (int i = 0; i < lines.size() / 20 + (lines.size() % 20 > 0 ? 1 : 0); ++i) {
                        chatRoom.sendMessage(String.join((CharSequence)"\n", lines.subList(i * 20, Math.min(lines.size(), (i + 1) * 20))));
                    }
                } else {
                    chatRoom.sendMessage(raw);
                }
            } else {
                this.sendFile(chatRoom, userId, botResponse);
            }
        }
        catch (Unauthorized e) {
            this.users.remove(userId);
        }
        catch (AlexandriaException e) {
            Logger.error(e);
        }
    }

    private void sendFile(RocketChatAPI.ChatRoom chatRoom, String userId, BotResponse response) {
        try {
            Path tempFile = Files.createTempFile(chatRoom.getRoomData().getRoomId() + "_" + userId + "_", response.fileName(), new FileAttribute[0]);
            Files.write(tempFile, io.intino.alexandria.Base64.decode(response.raw()), new OpenOption[0]);
            chatRoom.uploadFile(tempFile.toFile(), response.fileName(), response.title(), this.fileListener(tempFile));
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    private String timeZone(String userId) {
        if (this.userTimeZones.containsKey(userId)) {
            return this.userTimeZones.get(userId);
        }
        try {
            RocketChatClient client = new RocketChatClient(this.conf.chatUrl().replace("ws://", "http://").replace("wss://", "https://"), this.conf.botUser(), this.conf.botPassword());
            com.github.baloise.rocketchatrestclient.model.User info = client.getUsersApi().getInfo(userId);
            this.userTimeZones.put(userId, this.timeZone(info.getUtcOffset()));
            return this.userTimeZones.get(userId);
        }
        catch (IOException e) {
            return "Atlantic/Canary";
        }
    }

    private String timeZone(Integer offset) {
        if (offset == 0) {
            return "Z";
        }
        return (String)(offset > 0 ? "+" + String.format("%02d", offset) : String.format("%03d", offset)) + ":00";
    }

    private void tryLogIn(RocketChatAPI.ChatRoom chatRoom, String userId, RocketChatMessage message) {
        try {
            String[] credentials = message.getMessage().replaceFirst("login ", "").split("::");
            String token = this.token(credentials);
            new RestQueryBuilder(this.projects.values().iterator().next()).bearerAuth(token).get("servers").content();
            this.users.put(userId, new User(userId, token));
            this.saveUsers();
            chatRoom.sendMessage("Logged as " + credentials[0]);
        }
        catch (AlexandriaException e) {
            if (e.code().equals("403")) {
                chatRoom.sendMessage("User or password are wrong. Check it and try again");
            }
            chatRoom.sendMessage(e.getMessage());
        }
    }

    private String token(String[] userPassword) {
        Base64.Encoder encoder = Base64.getEncoder();
        return encoder.encodeToString((userPassword[0] + ":" + encoder.encodeToString(DigestUtils.md5(userPassword[1]))).getBytes());
    }

    private SubscribeListener emptySubscriber() {
        return (isSubscribed, subId) -> {};
    }

    @Override
    public void onDisconnect(boolean closedByServer) {
        Logger.warn("Disconnected. By server ->" + closedByServer);
    }

    @Override
    public void onConnectError(Exception ex) {
        Logger.error(ex);
        System.exit(-1);
    }

    private void saveUsers() {
        try {
            Files.writeString(this.conf.usersFile().toPath(), (CharSequence)this.users.entrySet().stream().map(e -> (String)e.getKey() + "\t" + ((User)e.getValue()).token() + "\t" + ((User)e.getValue()).project()).collect(Collectors.joining("\n")), new OpenOption[0]);
        }
        catch (IOException e2) {
            Logger.error(e2);
        }
    }

    private Map<String, User> loadUsers() {
        try {
            if (!this.conf.usersFile().exists()) {
                return new HashMap<String, User>();
            }
            return Files.lines(this.conf.usersFile().toPath()).map(l -> l.split("\t")).collect(Collectors.toMap(v -> v[0], v -> new User(v[0], v[1]).project(((String[])v).length > 2 && !"null".equals(v[2]) ? v[2] : null)));
        }
        catch (IOException e) {
            Logger.error(e);
            return new HashMap<String, User>();
        }
    }

    private Map<String, URL> loadProjects() {
        File file = this.conf.projectsFile();
        if (!file.exists()) {
            return new HashMap<String, URL>();
        }
        try {
            return Files.lines(file.toPath()).map(l -> l.split("\t")).collect(Collectors.toMap(l -> l[0], l -> this.url(l[1])));
        }
        catch (IOException e) {
            Logger.error(e);
            return new HashMap<String, URL>();
        }
    }

    public URL url(String path) {
        try {
            return new URL(path);
        }
        catch (MalformedURLException e) {
            Logger.error(e);
            return null;
        }
    }

    private FileListener fileListener(final Path tempFile) {
        return new FileListener(){

            @Override
            public void onUploadStarted(String s, String s1, String s2) {
            }

            @Override
            public void onUploadProgress(int i, String s, String s1, String s2) {
            }

            @Override
            public void onUploadComplete(int i, FileObject fileObject, String s, String s1, String s2) {
                tempFile.toFile().delete();
            }

            @Override
            public void onUploadError(ErrorObject errorObject, IOException e) {
                tempFile.toFile().delete();
            }

            @Override
            public void onSendFile(RocketChatMessage rocketChatMessage, ErrorObject errorObject) {
            }
        };
    }

    public static class ChatRoom
    extends Room {
        private final Room object;

        public ChatRoom(Room object) {
            super(ChatRoom.cover(object));
            this.object = object;
        }

        @Override
        public String getRoomName() {
            return this.object.getRoomName().isEmpty() ? this.getRoomId() : this.object.getRoomName();
        }

        @Override
        public String getRoomId() {
            return this.object.getRoomId();
        }

        public Type type() {
            return Type.valueOf(((Object)((Object)this.object.getRoomType())).toString());
        }

        @Override
        public UserObject getUserInfo() {
            return this.object.getUserInfo();
        }

        private static JSONObject cover(Room object) {
            try {
                return new JSONObject().put("_id", object.getRoomId()).put("t", "c");
            }
            catch (JSONException e) {
                return new JSONObject();
            }
        }

        public static enum Type {
            PUBLIC,
            PRIVATE,
            ONE_TO_ONE;

        }
    }
}

