/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.restaccessor.core;

import io.intino.alexandria.logger.Logger;
import java.io.IOException;
import java.net.URI;
import java.util.function.Consumer;
import javax.websocket.ClientEndpoint;
import javax.websocket.CloseReason;
import javax.websocket.ContainerProvider;
import javax.websocket.OnClose;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;

@ClientEndpoint
public class RestAccessorNotifier
implements io.intino.alexandria.restaccessor.RestAccessorNotifier {
    private String webSocketUri;
    private Session session;
    private Consumer<String> listener;

    @Override
    public void listen(Consumer<String> listener, String webSocketUri) {
        this.webSocketUri = webSocketUri;
        this.listener = listener;
        this.connect();
    }

    @Override
    public void close() {
        try {
            if (this.session != null) {
                this.session.close();
                this.session = null;
            }
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    @OnOpen
    public void onOpen(Session session) {
        this.session = session;
    }

    @OnMessage
    public void onMessage(String message) {
        this.listener.accept(message);
    }

    @OnClose
    public void onClose(Session session, CloseReason reason) {
        this.session = null;
    }

    public void sendMessage(String message) {
        if (this.session == null) {
            return;
        }
        this.session.getAsyncRemote().sendText(message);
    }

    private void connect() {
        if (this.session != null) {
            return;
        }
        try {
            this.session = ContainerProvider.getWebSocketContainer().connectToServer(this, new URI(this.webSocketUri));
        }
        catch (Exception e) {
            Logger.error(e);
        }
    }
}

