/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.restaccessor.core;

import io.intino.alexandria.Resource;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.restaccessor.Response;
import io.intino.alexandria.restaccessor.RestAccessor;
import io.intino.alexandria.restaccessor.core.Signer;
import io.intino.alexandria.restaccessor.exceptions.RestfulFailure;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.LaxRedirectStrategy;

public class RestAccessor
implements io.intino.alexandria.restaccessor.RestAccessor {
    private final int timeOutMillis;

    public RestAccessor() {
        this.timeOutMillis = 120000;
    }

    public RestAccessor(int timeOutMillis) {
        this.timeOutMillis = timeOutMillis;
    }

    @Override
    public Response get(URL url, String path) throws RestfulFailure {
        return this.get(url, path, Collections.emptyMap());
    }

    @Override
    public Response get(URL url, String path, Map<String, String> parameters) throws RestfulFailure {
        return this.doGet(url, path, this.parametersToNameValuePairs(parameters));
    }

    @Override
    public Resource getResource(URL url, String path) throws RestfulFailure {
        return this.doGetFile(url, path, Collections.emptyList());
    }

    @Override
    public Resource getResource(URL url, String path, Map<String, String> parameters) throws RestfulFailure {
        return this.doGetFile(url, path, this.parametersToNameValuePairs(parameters));
    }

    @Override
    public Response post(URL url, String path) throws RestfulFailure {
        return this.post(url, path, Collections.emptyMap());
    }

    @Override
    public Response post(URL url, String path, String body) throws RestfulFailure {
        return this.doPost(url, path, this.entityOf(body));
    }

    @Override
    public Response post(URL url, String path, Map<String, String> parameters) throws RestfulFailure {
        return this.doPost(url, path, this.entityOf(parameters));
    }

    @Override
    public Response post(URL url, String path, Resource resource) throws RestfulFailure {
        return this.doPost(url, path, this.multipartEntityOf(Collections.emptyMap(), Collections.singletonList(resource)));
    }

    @Override
    public Response post(URL url, String path, List<Resource> resourceList) throws RestfulFailure {
        return this.doPost(url, path, this.multipartEntityOf(Collections.emptyMap(), resourceList));
    }

    @Override
    public Response post(URL url, String path, Map<String, String> parameters, List<Resource> resourceList) throws RestfulFailure {
        if (resourceList.size() <= 0) {
            return this.doPost(url, path, this.entityOf(parameters));
        }
        return this.doPost(url, path, this.multipartEntityOf(parameters, resourceList));
    }

    @Override
    public Response put(URL url, String path) throws RestfulFailure {
        return this.put(url, path, Collections.emptyMap());
    }

    @Override
    public Response put(URL url, String path, Map<String, String> parameters) throws RestfulFailure {
        return this.doPut(url, path, this.entityOf(parameters));
    }

    @Override
    public Response put(URL url, String path, Resource resource) throws RestfulFailure {
        return this.doPut(url, path, this.multipartEntityOf(Collections.emptyMap(), Collections.singletonList(resource)));
    }

    @Override
    public Response put(URL url, String path, List<Resource> resourceList) throws RestfulFailure {
        return this.doPut(url, path, this.multipartEntityOf(Collections.emptyMap(), resourceList));
    }

    @Override
    public Response put(URL url, String path, Map<String, String> parameters, List<Resource> resourceList) throws RestfulFailure {
        if (resourceList.size() <= 0) {
            return this.doPost(url, path, this.entityOf(parameters));
        }
        return this.doPut(url, path, this.multipartEntityOf(parameters, resourceList));
    }

    @Override
    public Response delete(URL url, String path) throws RestfulFailure {
        return this.doDelete(url, path, Collections.emptyList());
    }

    @Override
    public Response delete(URL url, String path, Map<String, String> parameters) throws RestfulFailure {
        return this.doDelete(url, path, this.parametersToNameValuePairs(parameters));
    }

    @Override
    public RestAccessor.RestfulSecureConnection secure(final URL url, final URL certificate, final String password) {
        return new RestAccessor.RestfulSecureConnection(){

            @Override
            public Response get(String path) throws RestfulFailure {
                return this.get(path, Collections.emptyMap());
            }

            @Override
            public Response get(String path, Map<String, String> parameters) throws RestfulFailure {
                List<NameValuePair> getParameters = RestAccessor.this.parametersToNameValuePairs(parameters);
                getParameters.addAll(RestAccessor.this.parametersToNameValuePairs(RestAccessor.this.secureParameters(new HashMap<String, String>(parameters), certificate, password)));
                return RestAccessor.this.doGet(url, path, getParameters);
            }

            @Override
            public Resource getResource(String path) throws RestfulFailure {
                return RestAccessor.this.doGetFile(url, path, RestAccessor.this.parametersToNameValuePairs(RestAccessor.this.secureParameters(Collections.emptyMap(), certificate, password)));
            }

            @Override
            public Resource getResource(String path, Map<String, String> parameters) throws RestfulFailure {
                return RestAccessor.this.doGetFile(url, path, RestAccessor.this.parametersToNameValuePairs(RestAccessor.this.secureParameters(parameters, certificate, password)));
            }

            @Override
            public Response post(String path) throws RestfulFailure {
                return this.post(path, Collections.emptyMap());
            }

            @Override
            public Response post(String path, String body) throws RestfulFailure {
                return RestAccessor.this.doPost(url, path, this.entityOf(body));
            }

            @Override
            public Response post(String path, Map<String, String> parameters) throws RestfulFailure {
                return RestAccessor.this.doPost(url, path, this.entityOf(parameters));
            }

            @Override
            public Response post(String path, Resource resource) throws RestfulFailure {
                return RestAccessor.this.doPost(url, path, RestAccessor.this.multipartEntityOf(Collections.emptyMap(), Collections.singletonList(resource), certificate, password));
            }

            @Override
            public Response post(String path, List<Resource> resourceList) throws RestfulFailure {
                return RestAccessor.this.doPost(url, path, RestAccessor.this.multipartEntityOf(Collections.emptyMap(), resourceList, certificate, password));
            }

            @Override
            public Response post(String path, Map<String, String> parameters, List<Resource> resourceList) throws RestfulFailure {
                if (resourceList.size() <= 0) {
                    return RestAccessor.this.doPost(url, path, this.entityOf(parameters));
                }
                return RestAccessor.this.doPost(url, path, RestAccessor.this.multipartEntityOf(parameters, resourceList, certificate, password));
            }

            @Override
            public Response put(String path) throws RestfulFailure {
                return this.put(path, Collections.emptyMap());
            }

            @Override
            public Response put(String path, Map<String, String> parameters) throws RestfulFailure {
                return RestAccessor.this.doPut(url, path, this.entityOf(parameters));
            }

            @Override
            public Response put(String path, List<Resource> resourceList) throws RestfulFailure {
                return RestAccessor.this.doPost(url, path, RestAccessor.this.multipartEntityOf(Collections.emptyMap(), resourceList, certificate, password));
            }

            @Override
            public Response put(String path, Map<String, String> parameters, List<Resource> resourceList) throws RestfulFailure {
                if (resourceList.size() <= 0) {
                    return RestAccessor.this.doPost(url, path, this.entityOf(parameters));
                }
                return RestAccessor.this.doPost(url, path, RestAccessor.this.multipartEntityOf(parameters, resourceList, certificate, password));
            }

            @Override
            public Response delete(String path) throws RestfulFailure {
                return this.delete(path, Collections.emptyMap());
            }

            @Override
            public Response delete(String path, Map<String, String> parameters) throws RestfulFailure {
                List<NameValuePair> getParameters = RestAccessor.this.parametersToNameValuePairs(parameters);
                getParameters.addAll(RestAccessor.this.parametersToNameValuePairs(RestAccessor.this.secureParameters(new HashMap<String, String>(parameters), certificate, password)));
                return RestAccessor.this.doDelete(url, path, getParameters);
            }

            private HttpEntity entityOf(Map<String, String> parameters) throws RestfulFailure {
                try {
                    List<NameValuePair> entityParameters = RestAccessor.this.parametersToNameValuePairs(parameters);
                    entityParameters.addAll(RestAccessor.this.parametersToNameValuePairs(RestAccessor.this.secureParameters(new HashMap<String, String>(parameters), certificate, password)));
                    return new UrlEncodedFormEntity(entityParameters, "UTF-8");
                }
                catch (UnsupportedEncodingException exception) {
                    throw new RestfulFailure(exception.getMessage());
                }
            }

            private HttpEntity entityOf(String body) throws RestfulFailure {
                try {
                    StringEntity entity = new StringEntity(body);
                    entity.setContentEncoding("UTF-8");
                    return entity;
                }
                catch (UnsupportedEncodingException e) {
                    Logger.error(e);
                    throw new RestfulFailure(e.getMessage());
                }
            }
        };
    }

    @Override
    public RestAccessor.RestfulSecureConnection secure(final URL url, final String token) {
        return new RestAccessor.RestfulSecureConnection(){

            @Override
            public Response get(String path) throws RestfulFailure {
                return this.get(path, Collections.emptyMap());
            }

            @Override
            public Response get(String path, Map<String, String> parameters) throws RestfulFailure {
                return RestAccessor.this.doGet(url, path, RestAccessor.this.parametersToNameValuePairs(parameters), this.headers());
            }

            @Override
            public Resource getResource(String path) throws RestfulFailure {
                return RestAccessor.this.doGetFile(url, path, Collections.emptyList(), this.headers());
            }

            @Override
            public Resource getResource(String path, Map<String, String> parameters) throws RestfulFailure {
                return RestAccessor.this.doGetFile(url, path, RestAccessor.this.parametersToNameValuePairs(parameters), this.headers());
            }

            @Override
            public Response post(String path) throws RestfulFailure {
                return this.post(path, Collections.emptyMap());
            }

            @Override
            public Response post(String path, String body) throws RestfulFailure {
                return RestAccessor.this.doPost(url, path, this.entityOf(body), this.headers());
            }

            @Override
            public Response post(String path, Map<String, String> parameters) throws RestfulFailure {
                return RestAccessor.this.doPost(url, path, this.entityOf(parameters), this.headers());
            }

            @Override
            public Response post(String path, Resource resource) throws RestfulFailure {
                return RestAccessor.this.doPost(url, path, RestAccessor.this.multipartEntityOf(Collections.emptyMap(), Collections.singletonList(resource)), this.headers());
            }

            @Override
            public Response post(String path, List<Resource> resourceList) throws RestfulFailure {
                return RestAccessor.this.doPost(url, path, RestAccessor.this.multipartEntityOf(Collections.emptyMap(), resourceList), this.headers());
            }

            @Override
            public Response post(String path, Map<String, String> parameters, List<Resource> resourceList) throws RestfulFailure {
                if (resourceList.size() <= 0) {
                    return RestAccessor.this.doPost(url, path, this.entityOf(parameters), this.headers());
                }
                return RestAccessor.this.doPost(url, path, RestAccessor.this.multipartEntityOf(parameters, resourceList), this.headers());
            }

            @Override
            public Response put(String path) throws RestfulFailure {
                return this.put(path, Collections.emptyMap());
            }

            @Override
            public Response put(String path, Map<String, String> parameters) throws RestfulFailure {
                return RestAccessor.this.doPut(url, path, this.entityOf(parameters), this.headers());
            }

            @Override
            public Response put(String path, List<Resource> resourceList) throws RestfulFailure {
                return RestAccessor.this.doPut(url, path, RestAccessor.this.multipartEntityOf(Collections.emptyMap(), resourceList), this.headers());
            }

            @Override
            public Response put(String path, Map<String, String> parameters, List<Resource> resourceList) throws RestfulFailure {
                if (resourceList.size() <= 0) {
                    return RestAccessor.this.doPut(url, path, this.entityOf(parameters), this.headers());
                }
                return RestAccessor.this.doPut(url, path, RestAccessor.this.multipartEntityOf(parameters, resourceList), this.headers());
            }

            @Override
            public Response delete(String path) throws RestfulFailure {
                return this.delete(path, Collections.emptyMap());
            }

            @Override
            public Response delete(String path, Map<String, String> parameters) throws RestfulFailure {
                return RestAccessor.this.doDelete(url, path, RestAccessor.this.parametersToNameValuePairs(parameters), this.headers());
            }

            private HttpEntity entityOf(Map<String, String> parameters) throws RestfulFailure {
                try {
                    List<NameValuePair> entityParameters = RestAccessor.this.parametersToNameValuePairs(parameters);
                    entityParameters.addAll(RestAccessor.this.parametersToNameValuePairs(parameters));
                    return new UrlEncodedFormEntity(entityParameters, "UTF-8");
                }
                catch (UnsupportedEncodingException exception) {
                    throw new RestfulFailure(exception.getMessage());
                }
            }

            private HttpEntity entityOf(String body) throws RestfulFailure {
                try {
                    StringEntity entity = new StringEntity(body);
                    entity.setContentEncoding("UTF-8");
                    entity.setContentType("application/json");
                    return entity;
                }
                catch (UnsupportedEncodingException e) {
                    Logger.error(e);
                    throw new RestfulFailure(e.getMessage());
                }
            }

            private Map<String, String> headers() {
                return new HashMap<String, String>(){
                    {
                        this.put("Authorization", token);
                    }
                };
            }
        };
    }

    private String pathUrl(URL url, String path) {
        String baseUrl = url.toString();
        if (baseUrl.endsWith("/")) {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
        }
        return path.isEmpty() ? baseUrl : baseUrl + (String)(path.startsWith("/") ? path : "/" + path);
    }

    private HttpClient client() {
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(this.timeOutMillis).build();
        return HttpClientBuilder.create().setRedirectStrategy(new LaxRedirectStrategy()).setDefaultRequestConfig(requestConfig).build();
    }

    private Response doGet(URL url, String path, List<NameValuePair> parameters) throws RestfulFailure {
        return this.doGet(url, path, parameters, Collections.emptyMap());
    }

    private Response doGet(URL url, String path, List<NameValuePair> parameters, Map<String, String> headers) throws RestfulFailure {
        try {
            URIBuilder uriBuilder = new URIBuilder(this.pathUrl(url, path)).setParameters(parameters);
            return this.executeMethod(new HttpGet(uriBuilder.build().toURL().toString()), headers);
        }
        catch (MalformedURLException | URISyntaxException exception) {
            throw new RestfulFailure(exception.getMessage());
        }
    }

    private Resource doGetFile(URL url, String path, List<NameValuePair> parameters) throws RestfulFailure {
        return this.doGetFile(url, path, parameters, Collections.emptyMap());
    }

    private Resource doGetFile(URL url, String path, List<NameValuePair> parameters, Map<String, String> headers) throws RestfulFailure {
        try {
            HttpResponse response;
            URIBuilder uriBuilder = new URIBuilder(this.pathUrl(url, path)).setParameters(parameters);
            try {
                HttpGet httpGet = new HttpGet(uriBuilder.build().toURL().toString());
                headers.forEach(httpGet::setHeader);
                response = this.client().execute(httpGet);
            }
            catch (IOException exception) {
                throw new RestfulFailure(exception.getMessage());
            }
            int status = response.getStatusLine().getStatusCode();
            if (status < 200 || status >= 300) {
                String errorMessage = response.containsHeader("error-message") ? response.getFirstHeader("error-message").getValue() : "";
                String format = String.format("%s => %d - %s", url, status, response.getStatusLine().getReasonPhrase() + ". " + errorMessage);
                throw new RestfulFailure(String.valueOf(status), format);
            }
            HttpEntity entity = response.getEntity();
            return new Resource("content", entity.getContent());
        }
        catch (IOException | URISyntaxException exception) {
            throw new RestfulFailure(exception.getMessage());
        }
    }

    private Response doPost(URL url, String path, HttpEntity entity) throws RestfulFailure {
        return this.doPost(url, path, entity, Collections.emptyMap());
    }

    private Response doPost(URL url, String path, HttpEntity entity, Map<String, String> headers) throws RestfulFailure {
        HttpPost post = new HttpPost(this.pathUrl(url, path));
        post.setEntity(entity);
        return this.executeMethod(post, headers);
    }

    private Response doPut(URL url, String path, HttpEntity entity) throws RestfulFailure {
        return this.doPut(url, path, entity, Collections.emptyMap());
    }

    private Response doPut(URL url, String path, HttpEntity entity, Map<String, String> headers) throws RestfulFailure {
        HttpPut put = new HttpPut(this.pathUrl(url, path));
        put.setEntity(entity);
        return this.executeMethod(put, headers);
    }

    private Response doDelete(URL url, String path, List<NameValuePair> parameters) throws RestfulFailure {
        return this.doDelete(url, path, parameters, Collections.emptyMap());
    }

    private Response doDelete(URL url, String path, List<NameValuePair> parameters, Map<String, String> headers) throws RestfulFailure {
        try {
            URIBuilder uriBuilder = new URIBuilder(this.pathUrl(url, path)).setParameters(parameters);
            return this.executeMethod(new HttpDelete(uriBuilder.build().toURL().toString()), headers);
        }
        catch (MalformedURLException | URISyntaxException exception) {
            throw new RestfulFailure(exception.getMessage());
        }
    }

    private Response executeMethod(HttpRequestBase method, Map<String, String> headers) throws RestfulFailure {
        HttpResponse response;
        try {
            headers.forEach(method::setHeader);
            response = this.client().execute(method);
        }
        catch (IOException exception) {
            throw new RestfulFailure(exception.getMessage());
        }
        int status = response.getStatusLine().getStatusCode();
        if (status < 200 || status >= 300) {
            throw new RestfulFailure(String.valueOf(status), this.getErrorMessage(response));
        }
        return this.responseOf(response);
    }

    private String getErrorMessage(HttpResponse response) {
        try {
            InputStream content = response.getEntity().getContent();
            return RestAccessor.toString(content);
        }
        catch (IOException e) {
            return "";
        }
    }

    private HttpEntity entityOf(Map<String, String> parameters) throws RestfulFailure {
        try {
            return new UrlEncodedFormEntity(this.parametersToNameValuePairs(parameters), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RestfulFailure(e.getMessage());
        }
    }

    private HttpEntity entityOf(String body) throws RestfulFailure {
        try {
            StringEntity entity = new StringEntity(body);
            entity.setContentEncoding("UTF-8");
            return entity;
        }
        catch (UnsupportedEncodingException e) {
            Logger.error(e);
            throw new RestfulFailure(e.getMessage());
        }
    }

    private HttpEntity multipartEntityOf(Map<String, String> parameterList, List<Resource> resourceList) throws RestfulFailure {
        return this.multipartEntityOf(parameterList, resourceList, null, null);
    }

    private HttpEntity multipartEntityOf(Map<String, String> parameters, List<Resource> resourceList, URL certificate, String password) throws RestfulFailure {
        MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create();
        entityBuilder.setContentType(ContentType.MULTIPART_FORM_DATA);
        entityBuilder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        entityBuilder.setCharset(Charset.forName("UTF-8"));
        this.addResources(entityBuilder, resourceList);
        this.addParameters(entityBuilder, parameters);
        this.addParameters(entityBuilder, this.secureParameters(parameters, certificate, password));
        return entityBuilder.build();
    }

    private List<NameValuePair> parametersToNameValuePairs(Map<String, String> parameters) {
        ArrayList<NameValuePair> result = new ArrayList<NameValuePair>();
        parameters.forEach((name, value) -> result.add(new NameValuePair((String)name, (String)value){
            final /* synthetic */ String val$name;
            final /* synthetic */ String val$value;
            {
                this.val$name = string;
                this.val$value = string2;
            }

            @Override
            public String getName() {
                return this.val$name;
            }

            @Override
            public String getValue() {
                return this.val$value;
            }
        }));
        return result;
    }

    private void addResources(MultipartEntityBuilder builder, List<Resource> resourceList) {
        resourceList.forEach(r -> this.addResource(builder, (Resource)r));
    }

    private void addResource(MultipartEntityBuilder builder, Resource resource) {
        if (resource == null) {
            return;
        }
        ContentType contentType = resource.type() != null ? ContentType.create(resource.type()) : ContentType.APPLICATION_OCTET_STREAM;
        builder.addPart(resource.name(), new InputStreamBody(resource.stream(), contentType, resource.name()));
    }

    private void addParameters(MultipartEntityBuilder builder, Map<String, String> parameterList) {
        parameterList.forEach((key, value) -> this.addParameter(builder, (String)key, (String)value));
    }

    private void addParameter(MultipartEntityBuilder builder, String key, String value) {
        builder.addPart(key, new StringBody(value, ContentType.APPLICATION_JSON));
    }

    private Map<String, String> secureParameters(Map<String, String> parameters, URL certificate, String password) throws RestfulFailure {
        if (certificate == null) {
            return Collections.emptyMap();
        }
        try {
            Signer signer = new Signer();
            long timestamp = new Date().getTime();
            String hash = signer.hash(parameters, timestamp);
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("timestamp", String.valueOf(timestamp));
            result.put("hash", hash);
            result.put("signature", signer.sign(hash, certificate, password));
            return result;
        }
        catch (Exception exception) {
            throw new RestfulFailure(String.format("Could not sign with certificate: %s", certificate.toString()));
        }
    }

    private Response responseOf(final HttpResponse response) {
        return new Response(){

            @Override
            public int code() {
                return response.getStatusLine().getStatusCode();
            }

            @Override
            public String content() {
                try {
                    return response == null ? null : this.stringContentOf(response.getEntity().getContent());
                }
                catch (IOException e) {
                    return null;
                }
            }

            @Override
            public InputStream contentAsStream() {
                try {
                    return response == null ? null : response.getEntity().getContent();
                }
                catch (IOException e) {
                    return null;
                }
            }

            private String stringContentOf(InputStream input) {
                try {
                    return RestAccessor.toString(input);
                }
                catch (IOException e) {
                    Logger.error(e);
                    return null;
                }
            }
        };
    }

    private static String toString(InputStream content) throws IOException {
        return IOUtils.toString(content, StandardCharsets.UTF_8);
    }
}

