/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.restaccessor.core;

import io.intino.alexandria.restaccessor.core.ExternalSignatureSignerInfoGenerator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CRLException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.BERConstructedOctetString;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.CertificateList;
import org.bouncycastle.asn1.x509.X509CertificateStructure;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;

public class ExternalSignatureCMSSignedDataGenerator {
    private ArrayList<Object> certs = new ArrayList();
    private ArrayList<Object> crls = new ArrayList();
    private ArrayList<Object> signerInfs = new ArrayList();

    public void addCertificatesAndCRLs(CertStore certStore) throws CertStoreException, CMSException {
        try {
            for (X509Certificate x509Certificate : certStore.getCertificates(null)) {
                this.certs.add(new X509CertificateStructure((ASN1Sequence)this.makeObj(x509Certificate.getEncoded())));
            }
        }
        catch (IOException e) {
            throw new CMSException("error processing certs", e);
        }
        catch (CertificateEncodingException e) {
            throw new CMSException("error encoding certs", e);
        }
        try {
            for (X509CRL x509CRL : certStore.getCRLs(null)) {
                this.crls.add(new CertificateList((ASN1Sequence)this.makeObj(x509CRL.getEncoded())));
            }
        }
        catch (IOException e) {
            throw new CMSException("error processing crls", e);
        }
        catch (CRLException e) {
            throw new CMSException("error encoding crls", e);
        }
    }

    private DERObject makeObj(byte[] encoding) throws IOException {
        if (encoding == null) {
            return null;
        }
        ByteArrayInputStream bIn = new ByteArrayInputStream(encoding);
        ASN1InputStream aIn = new ASN1InputStream(bIn);
        DERObject derObject = aIn.readObject();
        aIn.close();
        return derObject;
    }

    private AlgorithmIdentifier makeAlgId(String oid, byte[] params) throws IOException {
        if (params != null) {
            return new AlgorithmIdentifier(new DERObjectIdentifier(oid), this.makeObj(params));
        }
        return new AlgorithmIdentifier(new DERObjectIdentifier(oid), new DERNull());
    }

    public void addSignerInf(ExternalSignatureSignerInfoGenerator si) {
        this.signerInfs.add(si);
    }

    /*
     * WARNING - void declaration
     */
    public CMSSignedData generate(CMSProcessable content, boolean encapsulate) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException, InvalidAlgorithmParameterException, CertStoreException {
        void var9_14;
        Iterator<Object> it;
        DEREncodableVector signerInfos = new DEREncodableVector();
        DEREncodableVector digestAlgs = new DEREncodableVector();
        DERObjectIdentifier contentTypeOID = new DERObjectIdentifier(CMSSignedDataGenerator.DATA);
        DERSet certificates = null;
        for (ExternalSignatureSignerInfoGenerator externalSignatureSignerInfoGenerator : this.signerInfs) {
            try {
                AlgorithmIdentifier digAlgId = this.makeAlgId(externalSignatureSignerInfoGenerator.getDigestAlgOID(), externalSignatureSignerInfoGenerator.getDigestAlgParams());
                digestAlgs.add(digAlgId);
                signerInfos.add(externalSignatureSignerInfoGenerator.generate());
            }
            catch (IOException e) {
                throw new CMSException("encoding error.", e);
            }
            catch (CertificateEncodingException e) {
                throw new CMSException("error creating sid.", e);
            }
        }
        if (this.certs.size() != 0) {
            DEREncodableVector v = new DEREncodableVector();
            it = this.certs.iterator();
            while (it.hasNext()) {
                v.add((DEREncodable)it.next());
            }
            certificates = new DERSet(v);
        }
        DERSet certrevlist = null;
        if (this.crls.size() != 0) {
            DEREncodableVector dEREncodableVector = new DEREncodableVector();
            it = this.crls.iterator();
            while (it.hasNext()) {
                dEREncodableVector.add((DEREncodable)it.next());
            }
            certrevlist = new DERSet(dEREncodableVector);
        }
        if (encapsulate) {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            try {
                content.write(bOut);
            }
            catch (IOException e) {
                throw new CMSException("encapsulation error.", e);
            }
            BERConstructedOctetString octs = new BERConstructedOctetString(bOut.toByteArray());
            ContentInfo contentInfo = new ContentInfo(contentTypeOID, octs);
        } else {
            ContentInfo contentInfo = new ContentInfo(contentTypeOID, null);
        }
        SignedData sd = new SignedData(new DERSet(digestAlgs), (ContentInfo)var9_14, certificates, certrevlist, new DERSet(signerInfos));
        ContentInfo contentInfo = new ContentInfo(PKCSObjectIdentifiers.signedData, sd);
        return new CMSSignedData(content, contentInfo);
    }
}

