/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.restaccessor;

import io.intino.alexandria.Base64;
import io.intino.alexandria.Json;
import io.intino.alexandria.Resource;
import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.exceptions.ExceptionFactory;
import io.intino.alexandria.exceptions.InternalServerError;
import io.intino.alexandria.restaccessor.Response;
import io.intino.alexandria.restaccessor.adapters.RequestAdapter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.message.BasicNameValuePair;

public class RestQueryBuilder {
    private final URL url;
    private final List<NameValuePair> queryParameters;
    private final HttpClient client;
    private final Map<String, String> headerParameters;
    private final Map<String, String> entityParts;
    private final List<Resource> resources;
    private int timeOutMillis;
    private Auth auth;

    public RestQueryBuilder(URL url) {
        this.url = url;
        this.timeOutMillis = 120000;
        this.queryParameters = new ArrayList<NameValuePair>();
        this.headerParameters = new LinkedHashMap<String, String>();
        this.entityParts = new LinkedHashMap<String, String>();
        this.resources = new ArrayList<Resource>();
        this.client = this.client();
    }

    public RestQueryBuilder timeOut(int timeOutMillis) {
        this.timeOutMillis = timeOutMillis;
        return this;
    }

    public RestQueryBuilder basicAuth(String user, String password) {
        this.auth = Auth.Basic.with(Base64.encode((user + ":" + password).getBytes()));
        return this;
    }

    public RestQueryBuilder bearerAuth(String token) {
        this.auth = Auth.Bearer.with(token);
        return this;
    }

    public RestQueryBuilder queryParameter(String name, Object value) {
        if (value != null) {
            this.queryParameters.add(new BasicNameValuePair(name, RequestAdapter.adapt(value)));
        }
        return this;
    }

    public RestQueryBuilder headerParameter(String name, Object value) {
        if (value != null) {
            this.headerParameters.put(name, RequestAdapter.adapt(value));
        }
        return this;
    }

    public RestQueryBuilder entityPart(String name, Object content) {
        if (content != null) {
            this.entityParts.put(name, RequestAdapter.adapt(content));
        }
        return this;
    }

    public RestQueryBuilder entityPart(Resource resource) {
        this.resources.add(resource);
        return this;
    }

    public Response get(String path) throws AlexandriaException {
        return this.buildRequest("GET", path).execute();
    }

    public Response post(String path) throws AlexandriaException {
        return this.buildRequest("POST", path).execute();
    }

    public Response put(String path) throws AlexandriaException {
        return this.buildRequest("PUT", path).execute();
    }

    public Response patch(String path) throws AlexandriaException {
        return this.buildRequest("PATCH", path).execute();
    }

    public Response delete(String path) throws AlexandriaException {
        return this.buildRequest("DELETE", path).execute();
    }

    private MethodExecutor buildRequest(String methodName, String path) throws AlexandriaException {
        try {
            HttpRequestBase method = this.method(methodName);
            method.setURI(new URIBuilder(this.pathUrl(this.url, path)).setParameters(this.queryParameters).build());
            if (this.auth != null) {
                method.setHeader("Authorization", this.auth.name() + " " + this.auth.token);
            }
            this.headerParameters.forEach(method::setHeader);
            if (!this.entityParts.isEmpty() && method instanceof HttpEntityEnclosingRequestBase) {
                ((HttpEntityEnclosingRequestBase)method).setEntity(this.buildEntity());
            }
            return () -> {
                try {
                    return this.responseFrom(this.client.execute(method));
                }
                catch (IOException e) {
                    throw new InternalServerError(e.getMessage());
                }
            };
        }
        catch (URISyntaxException exception) {
            throw new InternalServerError(exception.getMessage());
        }
    }

    private HttpEntity buildEntity() {
        if (this.resources.isEmpty() && this.entityParts.size() == 1) {
            return this.stringEntity(String.valueOf(this.entityParts.values().iterator().next()));
        }
        return this.multipartEntity();
    }

    private HttpEntity multipartEntity() {
        MultipartEntityBuilder builder = MultipartEntityBuilder.create().setContentType(ContentType.MULTIPART_FORM_DATA).setMode(HttpMultipartMode.BROWSER_COMPATIBLE).setCharset(StandardCharsets.UTF_8);
        this.resources.forEach(r -> builder.addPart(r.name(), new InputStreamBody(r.stream(), r.type() != null ? ContentType.create(r.type()) : ContentType.APPLICATION_OCTET_STREAM, r.name())));
        this.entityParts.forEach((key, value) -> builder.addPart((String)key, new StringBody((String)value, ContentType.APPLICATION_JSON)));
        return builder.build();
    }

    private HttpEntity stringEntity(String body) {
        StringEntity entity = new StringEntity(body, ContentType.APPLICATION_JSON);
        entity.setContentEncoding(StandardCharsets.UTF_8.displayName());
        return entity;
    }

    private HttpClient client() {
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(this.timeOutMillis).build();
        return HttpClientBuilder.create().setRedirectStrategy(new LaxRedirectStrategy()).setDefaultRequestConfig(requestConfig).build();
    }

    private HttpRequestBase method(String methodName) {
        if ("GET".equals(methodName)) {
            return new HttpGet();
        }
        if ("POST".equals(methodName)) {
            return new HttpPost();
        }
        if ("PATCH".equals(methodName)) {
            return new HttpPatch();
        }
        if ("PUT".equals(methodName)) {
            return new HttpPut();
        }
        return new HttpDelete();
    }

    private String pathUrl(URL url, String path) {
        String baseUrl = url.toString();
        if (baseUrl.endsWith("/")) {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
        }
        return path.isEmpty() ? baseUrl : baseUrl + (String)(path.startsWith("/") ? path : "/" + path);
    }

    private Response responseFrom(HttpResponse response) throws AlexandriaException {
        try {
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode < 200 || statusCode >= 300) {
                throw this.exception(statusCode, this.bodyContent(response));
            }
            return new RestResponse(statusCode, response.getEntity().getContent());
        }
        catch (IOException e) {
            return new RestResponse(response.getStatusLine().getStatusCode(), null);
        }
    }

    private AlexandriaException exception(int statusCode, String bodyContent) {
        AlexandriaException e;
        AlexandriaException alexandriaException = e = bodyContent.startsWith("{") ? Json.fromString(bodyContent, AlexandriaException.class) : null;
        if (e != null) {
            return ExceptionFactory.from(statusCode, e.getMessage(), e.parameters());
        }
        return ExceptionFactory.from(statusCode, bodyContent, Map.of());
    }

    private String bodyContent(HttpResponse response) {
        try {
            InputStream content = response.getEntity().getContent();
            return IOUtils.toString(content, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            return "";
        }
    }

    public static class RestResponse
    implements Response {
        private final int code;
        private final InputStream content;

        public RestResponse(int code, InputStream content) {
            this.code = code;
            this.content = content;
        }

        @Override
        public int code() {
            return this.code;
        }

        @Override
        public String content() {
            try {
                return IOUtils.toString(this.content, StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                return null;
            }
        }

        @Override
        public InputStream contentAsStream() {
            return this.content;
        }
    }

    static interface MethodExecutor {
        public Response execute() throws AlexandriaException;
    }

    private static enum Auth {
        Basic,
        Bearer;

        private String token;

        Auth with(String token) {
            this.token = token;
            return this;
        }

        public String token() {
            return this.token;
        }
    }
}

