/*
 * Decompiled with CFR 0.152.
 */
package com.rocketchat.core.uploader;

import com.rocketchat.common.data.model.ErrorObject;
import com.rocketchat.common.utils.MultipartUploader;
import com.rocketchat.common.utils.Utils;
import com.rocketchat.core.RocketChatAPI;
import com.rocketchat.core.callback.FileListener;
import com.rocketchat.core.callback.MessageListener;
import com.rocketchat.core.model.FileObject;
import com.rocketchat.core.model.RocketChatMessage;
import com.rocketchat.core.uploader.FileUploadToken;
import com.rocketchat.core.uploader.IFileUpload;
import java.io.File;
import java.io.IOException;
import java.util.Observable;
import java.util.Observer;

public class FileUploader
implements IFileUpload.UfsCreateListener,
IFileUpload.UfsCompleteListener,
MessageListener.MessageAckListener {
    public static final String DEFAULT_STORE = "Uploads";
    RocketChatAPI api;
    File file;
    String newFileName;
    String description;
    RocketChatAPI.ChatRoom room;
    String charset = "UTF-8";
    MultipartUploader multipart;
    FileListener fileListener;
    int statusCode;

    public FileUploader(RocketChatAPI api, File file, String newFileName, String description, RocketChatAPI.ChatRoom room, FileListener fileListener) {
        this.api = api;
        this.file = file;
        this.newFileName = newFileName;
        this.description = description;
        this.room = room;
        this.fileListener = fileListener;
    }

    public void startUpload() {
        this.api.createUFS(this.newFileName, (int)this.file.length(), Utils.getFileTypeUsingName(this.newFileName), this.room.getRoomData().getRoomId(), this.description, DEFAULT_STORE, this);
    }

    @Override
    public void onUfsCreate(final FileUploadToken token, ErrorObject error) {
        if (error == null) {
            this.fileListener.onUploadStarted(this.room.getRoomData().getRoomId(), this.newFileName, this.description);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        FileUploader.this.multipart = new MultipartUploader(token.getUrl(), FileUploader.this.charset);
                        FileUploader.this.multipart.addObserver(new Observer(){

                            @Override
                            public void update(Observable o, Object arg) {
                                if (arg != null) {
                                    FileUploader.this.fileListener.onUploadProgress((Integer)arg, FileUploader.this.room.getRoomData().getRoomId(), FileUploader.this.newFileName, FileUploader.this.description);
                                }
                            }
                        });
                        FileUploader.this.multipart.addFilePart("file", FileUploader.this.file);
                        FileUploader.this.statusCode = FileUploader.this.multipart.finish();
                        FileUploader.this.api.completeUFS(token.getFileId(), FileUploader.DEFAULT_STORE, token.getToken(), FileUploader.this);
                    }
                    catch (IOException e) {
                        FileUploader.this.fileListener.onUploadError(null, e);
                    }
                }
            }).start();
        } else {
            this.fileListener.onUploadError(error, null);
        }
    }

    @Override
    public void onUfsComplete(FileObject file, ErrorObject error) {
        if (error == null) {
            this.fileListener.onUploadComplete(this.statusCode, file, this.room.getRoomData().getRoomId(), this.newFileName, this.description);
            this.room.sendFileMessage(file, this);
        } else {
            this.fileListener.onUploadError(error, null);
        }
    }

    @Override
    public void onMessageAck(RocketChatMessage message, ErrorObject error) {
        this.fileListener.onSendFile(message, error);
    }
}

