/*
 * Decompiled with CFR 0.152.
 */
package com.rocketchat.core.rpc;

import com.rocketchat.common.data.rpc.RPC;
import org.json.JSONArray;

public class RoomRPC
extends RPC {
    private static final String CREATE_PUBLIC_GROUP = "createChannel";
    private static final String CREATE_PRIVATE_GROUP = "createPrivateGroup";
    private static final String DELETE_GROUP = "eraseRoom";
    private static final String ARCHIVE_ROOM = "archiveRoom";
    private static final String UNARCHIVE_ROOM = "unarchiveRoom";
    private static final String JOIN_PUBLIC_GROUP = "joinRoom";
    private static final String LEAVE_GROUP = "leaveRoom";
    private static final String HIDE_ROOM = "hideRoom";
    private static final String OPEN_ROOM = "openRoom";
    private static final String SET_FAVOURITE_ROOM = "toggleFavorite";
    private static final String SAVE_ROOM_SETTINGS = "saveRoomSettings";
    private static final String GET_ROOM_MEMBERS = "getUsersOfRoom";

    public static String createPublicGroup(int integer, String groupName, String[] users, Boolean readOnly) {
        JSONArray array = new JSONArray();
        for (int i = 0; i < users.length; ++i) {
            array.put(users[i]);
        }
        return RoomRPC.getRemoteMethodObject(integer, CREATE_PUBLIC_GROUP, groupName, array, readOnly).toString();
    }

    public static String createPrivateGroup(int integer, String groupName, String[] users) {
        JSONArray array = new JSONArray();
        for (int i = 0; i < users.length; ++i) {
            array.put(users[i]);
        }
        return RoomRPC.getRemoteMethodObject(integer, CREATE_PRIVATE_GROUP, groupName, array).toString();
    }

    public static String deleteGroup(int integer, String roomId) {
        return RoomRPC.getRemoteMethodObject(integer, DELETE_GROUP, roomId).toString();
    }

    public static String archieveRoom(int integer, String roomId) {
        return RoomRPC.getRemoteMethodObject(integer, ARCHIVE_ROOM, roomId).toString();
    }

    public static String unarchiveRoom(int integer, String roomId) {
        return RoomRPC.getRemoteMethodObject(integer, UNARCHIVE_ROOM, roomId).toString();
    }

    public static String joinPublicGroup(int integer, String roomId, String joinCode) {
        if (joinCode == null) {
            return RoomRPC.getRemoteMethodObject(integer, JOIN_PUBLIC_GROUP, roomId).toString();
        }
        return RoomRPC.getRemoteMethodObject(integer, JOIN_PUBLIC_GROUP, roomId, joinCode).toString();
    }

    public static String leaveGroup(int integer, String roomId) {
        return RoomRPC.getRemoteMethodObject(integer, LEAVE_GROUP, roomId).toString();
    }

    public static String hideRoom(int integer, String roomId) {
        return RoomRPC.getRemoteMethodObject(integer, HIDE_ROOM, roomId).toString();
    }

    public static String openRoom(int integer, String roomId) {
        return RoomRPC.getRemoteMethodObject(integer, OPEN_ROOM, roomId).toString();
    }

    public static String setFavouriteRoom(int integer, String roomId, Boolean isFavourite) {
        return RoomRPC.getRemoteMethodObject(integer, SET_FAVOURITE_ROOM, roomId, isFavourite).toString();
    }

    public static String saveRoomSettings(int integer, String roomId, String setting, String value) {
        return RoomRPC.getRemoteMethodObject(integer, SAVE_ROOM_SETTINGS, roomId, setting, value).toString();
    }

    public static String getRoomMembers(int integer, String roomId, Boolean allUsers) {
        return RoomRPC.getRemoteMethodObject(integer, GET_ROOM_MEMBERS, roomId, allUsers).toString();
    }
}

