/*
 * Decompiled with CFR 0.152.
 */
package com.rocketchat.core.rpc;

import com.rocketchat.common.data.rpc.RPC;
import com.rocketchat.common.utils.Utils;
import org.json.JSONException;
import org.json.JSONObject;

public class BasicRPC
extends RPC {
    private static final String LOGIN = "login";
    private static final String GET_USER_ROLES = "getUserRoles";
    private static final String GET_SUBSCRIPTIONS = "subscriptions/get";
    private static final String GET_ROOMS = "rooms/get";
    private static final String GET_ROOM_ROLES = "getRoomRoles";
    private static final String LIST_EMOJI = "listEmojiCustom";
    private static final String LOGOUT = "logout";

    public static String login(int integer, String username, String password) {
        JSONObject loginObject = new JSONObject();
        try {
            loginObject.put("user", new JSONObject().put("username", username));
            loginObject.put("password", new JSONObject().put("digest", Utils.getDigest(password)).put("algorithm", "sha-256"));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return BasicRPC.getRemoteMethodObject(integer, LOGIN, loginObject).toString();
    }

    public static String loginUsingToken(int integer, String token) {
        JSONObject loginObject = new JSONObject();
        try {
            loginObject.put("resume", token);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return BasicRPC.getRemoteMethodObject(integer, LOGIN, loginObject).toString();
    }

    public static String getUserRoles(int integer) {
        return BasicRPC.getRemoteMethodObject(integer, GET_USER_ROLES, new Object[0]).toString();
    }

    public static String getSubscriptions(int integer) {
        return BasicRPC.getRemoteMethodObject(integer, GET_SUBSCRIPTIONS, new Object[0]).toString();
    }

    public static String getRooms(int integer) {
        return BasicRPC.getRemoteMethodObject(integer, GET_ROOMS, new Object[0]).toString();
    }

    public static String getRoomRoles(int integer, String ... roomId) {
        return BasicRPC.getRemoteMethodObject(integer, GET_ROOM_ROLES, roomId).toString();
    }

    public static String listCustomEmoji(int integer) {
        return BasicRPC.getRemoteMethodObject(integer, LIST_EMOJI, new Object[0]).toString();
    }

    public static String logout(int integer) {
        return BasicRPC.getRemoteMethodObject(integer, LOGOUT, new Object[0]).toString();
    }
}

