/*
 * Decompiled with CFR 0.152.
 */
package com.rocketchat.core.model.attachment;

import com.rocketchat.core.model.attachment.TAttachment;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Attachment {
    protected String title;
    protected String type;
    protected String description;
    protected String title_link;
    protected Boolean title_link_download;

    Attachment(JSONObject object) {
        this.title = object.optString("title");
        this.type = object.optString("type");
        this.description = object.optString("description");
        this.title_link = object.optString("title_link");
        this.title_link_download = object.optBoolean("title_link_download");
    }

    public String getTitle() {
        return this.title;
    }

    public String getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public String getTitle_link() {
        return this.title_link;
    }

    public Boolean getTitle_link_download() {
        return this.title_link_download;
    }

    public static enum Type {
        TEXT_ATTACHMENT,
        IMAGE,
        AUDIO,
        VIDEO,
        OTHER;

    }

    public static class VideoAttachment
    extends Attachment
    implements TAttachment {
        String video_url;
        String video_type;
        int video_size;

        public VideoAttachment(JSONObject object) {
            super(object);
            this.video_url = object.optString("video_url");
            this.video_type = object.optString("video_type");
            this.video_size = object.optInt("video_type");
        }

        public String getVideo_url() {
            return this.video_url;
        }

        public String getVideo_type() {
            return this.video_type;
        }

        public int getVideo_size() {
            return this.video_size;
        }

        @Override
        public Type getAttachmentType() {
            return Type.VIDEO;
        }
    }

    public static class AudioAttachment
    extends Attachment
    implements TAttachment {
        String audio_url;
        String audio_type;
        int audio_size;

        public AudioAttachment(JSONObject object) {
            super(object);
            this.audio_url = object.optString("audio_url");
            this.audio_type = object.optString("audio_type");
            this.audio_size = object.optInt("audio_size");
        }

        public String getAudio_url() {
            return this.audio_url;
        }

        public String getAudio_type() {
            return this.audio_type;
        }

        public int getAudio_size() {
            return this.audio_size;
        }

        @Override
        public Type getAttachmentType() {
            return Type.AUDIO;
        }
    }

    public static class ImageAttachment
    extends Attachment
    implements TAttachment {
        String image_url;
        String image_type;
        int image_size;

        public ImageAttachment(JSONObject object) {
            super(object);
            this.image_url = object.optString("image_url");
            this.image_type = object.optString("image_type");
            this.image_size = object.optInt("image_size");
        }

        public String getImage_url() {
            return this.image_url;
        }

        public String getImage_type() {
            return this.image_type;
        }

        public int getImage_size() {
            return this.image_size;
        }

        @Override
        public Type getAttachmentType() {
            return Type.IMAGE;
        }
    }

    public static class TextAttachment
    implements TAttachment {
        private String text;
        private JSONObject translations;
        private String author_name;
        private String author_icon;
        private String message_link;
        private List<Attachment> attachments;
        private Date msgTimestamp;

        public TextAttachment(JSONObject object) {
            try {
                this.text = object.optString("text");
                this.translations = object.optJSONObject("translations");
                this.author_name = object.optString("author_name");
                this.author_icon = object.optString("author_icon");
                this.message_link = object.optString("message_link");
                if (object.opt("attachments") != null) {
                    this.attachments = new ArrayList<Attachment>();
                    JSONArray array = object.optJSONArray("attachments");
                    for (int i = 0; i < array.length(); ++i) {
                        this.attachments.add(new Attachment(array.optJSONObject(i)));
                    }
                }
                if (object.optJSONObject("ts") != null) {
                    this.msgTimestamp = new Date(object.getJSONObject("ts").getLong("$date"));
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }

        public String getText() {
            return this.text;
        }

        public JSONObject getTranslations() {
            return this.translations;
        }

        public String getAuthor_name() {
            return this.author_name;
        }

        public String getAuthor_icon() {
            return this.author_icon;
        }

        public String getMessage_link() {
            return this.message_link;
        }

        public List<Attachment> getAttachments() {
            return this.attachments;
        }

        public Date getMsgTimestamp() {
            return this.msgTimestamp;
        }

        @Override
        public Type getAttachmentType() {
            return Type.TEXT_ATTACHMENT;
        }
    }
}

