/*
 * Decompiled with CFR 0.152.
 */
package com.rocketchat.core.model;

import com.rocketchat.common.data.model.Room;
import java.util.Date;
import org.json.JSONException;
import org.json.JSONObject;

public class SubscriptionObject
extends Room {
    private Date roomCreated;
    private Date lastSeen;
    private Boolean open;
    private Boolean alert;
    private Integer unread;
    private Date updatedAt;
    private String subscriptionId;
    private String desktopNotifications;
    private String mobilePushNotifications;
    private String emailNotifications;

    public SubscriptionObject(JSONObject object) {
        super(object);
        try {
            this.roomId = object.getString("rid");
            if (object.optJSONObject("ts") != null) {
                this.roomCreated = new Date(object.getJSONObject("ts").getLong("$date"));
            }
            if (object.optJSONObject("ls") != null) {
                this.lastSeen = new Date(object.getJSONObject("ls").getLong("$date"));
            }
            this.open = object.getBoolean("open");
            this.alert = object.getBoolean("alert");
            this.unread = object.getInt("unread");
            this.updatedAt = new Date(object.getJSONObject("_updatedAt").getLong("$date"));
            this.subscriptionId = object.getString("_id");
            this.desktopNotifications = object.optString("desktopNotifications");
            this.mobilePushNotifications = object.optString("mobilePushNotifications");
            this.emailNotifications = object.optString("emailNotifications");
        }
        catch (JSONException e) {
            e.printStackTrace();
            System.out.println("name is " + this.getRoomName());
        }
    }

    public Date getRoomCreated() {
        return this.roomCreated;
    }

    public Date getLastSeen() {
        return this.lastSeen;
    }

    public Boolean getOpen() {
        return this.open;
    }

    public Boolean getAlert() {
        return this.alert;
    }

    public Integer getUnread() {
        return this.unread;
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }
}

