/*
 * Decompiled with CFR 0.152.
 */
package com.rocketchat.core.model;

import com.rocketchat.common.data.model.Message;
import com.rocketchat.core.model.FileObject;
import com.rocketchat.core.model.MessageUrl;
import com.rocketchat.core.model.attachment.Attachment;
import com.rocketchat.core.model.attachment.TAttachment;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class RocketChatMessage
extends Message {
    private JSONArray mentions;
    private JSONArray channels;
    private Boolean groupable;
    private List<MessageUrl> urls;
    private List<TAttachment> attachments;
    private String avatar;
    private Boolean parseUrls;
    private JSONObject translations;
    private List<String> starred_by;
    private JSONObject reactions;
    private JSONObject rawMessage;
    FileObject file;
    private static final String TYPE_MESSAGE_REMOVED = "rm";
    private static final String TYPE_ROOM_NAME_CHANGED = "r";
    private static final String TYPE_ROOM_ARCHIVED = "room-archived";
    private static final String TYPE_ROOM_UNARCHIVED = "room-unarchived";
    private static final String TYPE_USER_ADDED = "au";
    private static final String TYPE_USER_REMOVED = "ru";
    private static final String TYPE_USER_JOINED = "uj";
    private static final String TYPE_USER_LEFT = "ul";
    private static final String TYPE_USER_MUTED = "user-muted";
    private static final String TYPE_USER_UNMUTED = "user-unmuted";
    private static final String TYPE_WELCOME = "wm";
    private static final String TYPE_SUBSCRIPTION_ROLE_ADDED = "subscription-role-added";
    private static final String TYPE_SUBSCRIPTION_ROLE_REMOVED = "subscription-role-removed";

    public RocketChatMessage(JSONObject object) {
        super(object);
        int i;
        JSONArray array;
        this.mentions = object.optJSONArray("mentions");
        this.channels = object.optJSONArray("channels");
        this.groupable = object.optBoolean("groupable");
        if (object.opt("file") != null) {
            this.file = new FileObject(object.optJSONObject("file"));
        }
        if (object.opt("urls") != null) {
            this.urls = new ArrayList<MessageUrl>();
            array = object.optJSONArray("urls");
            for (i = 0; i < array.length(); ++i) {
                this.urls.add(new MessageUrl(array.optJSONObject(i)));
            }
        }
        if (object.opt("attachments") != null) {
            this.attachments = new ArrayList<TAttachment>();
            array = object.optJSONArray("attachments");
            for (i = 0; i < array.length(); ++i) {
                if (this.file == null) {
                    this.attachments.add(new Attachment.TextAttachment(array.optJSONObject(i)));
                    continue;
                }
                String type = this.file.getFileType();
                if (type.contains("image")) {
                    this.attachments.add(new Attachment.ImageAttachment(array.optJSONObject(i)));
                    continue;
                }
                if (type.contains("video")) {
                    this.attachments.add(new Attachment.VideoAttachment(array.optJSONObject(i)));
                    continue;
                }
                if (!type.contains("audio")) continue;
                this.attachments.add(new Attachment.AudioAttachment(array.optJSONObject(i)));
            }
        }
        this.avatar = object.optString("avatar");
        this.parseUrls = object.optBoolean("parseUrls");
        this.translations = object.optJSONObject("translations");
        if (object.opt("starred") != null) {
            this.starred_by = new ArrayList<String>();
            array = object.optJSONArray("starred");
            for (i = 0; i < array.length(); ++i) {
                this.starred_by.add(array.optJSONObject(i).optString("_id"));
            }
        }
        this.reactions = object.optJSONObject("reactions");
        this.rawMessage = object;
    }

    public JSONArray getMentions() {
        return this.mentions;
    }

    public JSONArray getChannels() {
        return this.channels;
    }

    public Boolean getGroupable() {
        return this.groupable;
    }

    public List<MessageUrl> getUrls() {
        return this.urls;
    }

    public List<TAttachment> getAttachments() {
        return this.attachments;
    }

    public String getAvatar() {
        return this.avatar;
    }

    public Boolean getParseUrls() {
        return this.parseUrls;
    }

    public JSONObject getTranslations() {
        return this.translations;
    }

    public JSONObject getRawJsonObject() {
        return this.rawMessage;
    }

    public Type getMsgType() {
        if (this.getMessagetype() != null && !this.getMessagetype().equals("")) {
            return RocketChatMessage.getType(this.getMessagetype());
        }
        if (this.getEditedBy() != null) {
            return Type.MESSAGE_EDITED;
        }
        if (this.starred_by != null) {
            return Type.MESSAGE_STARRED;
        }
        if (this.reactions != null) {
            return Type.MESSAGE_REACTION;
        }
        if (this.attachments != null) {
            return Type.ATTACHMENT;
        }
        return Type.TEXT;
    }

    private static Type getType(String s) {
        if (s.equals(TYPE_MESSAGE_REMOVED)) {
            return Type.MESSAGE_REMOVED;
        }
        if (s.equals(TYPE_ROOM_NAME_CHANGED)) {
            return Type.ROOM_NAME_CHANGED;
        }
        if (s.equals(TYPE_ROOM_ARCHIVED)) {
            return Type.ROOM_ARCHIVED;
        }
        if (s.equals(TYPE_ROOM_UNARCHIVED)) {
            return Type.ROOM_UNARCHIVED;
        }
        if (s.equals(TYPE_USER_ADDED)) {
            return Type.USER_ADDED;
        }
        if (s.equals(TYPE_USER_REMOVED)) {
            return Type.USER_REMOVED;
        }
        if (s.equals(TYPE_USER_JOINED)) {
            return Type.USER_JOINED;
        }
        if (s.equals(TYPE_USER_LEFT)) {
            return Type.USER_LEFT;
        }
        if (s.equals(TYPE_USER_MUTED)) {
            return Type.USER_MUTED;
        }
        if (s.equals(TYPE_USER_UNMUTED)) {
            return Type.USER_UNMUTED;
        }
        if (s.equals(TYPE_WELCOME)) {
            return Type.WELCOME;
        }
        if (s.equals(TYPE_SUBSCRIPTION_ROLE_ADDED)) {
            return Type.SUBSCRIPTION_ROLE_ADDED;
        }
        if (s.equals(TYPE_SUBSCRIPTION_ROLE_REMOVED)) {
            return Type.SUBSCRIPTION_ROLE_REMOVED;
        }
        return Type.OTHER;
    }

    public static enum Type {
        TEXT,
        ATTACHMENT,
        MESSAGE_EDITED,
        MESSAGE_STARRED,
        MESSAGE_REACTION,
        MESSAGE_REMOVED,
        ROOM_NAME_CHANGED,
        ROOM_ARCHIVED,
        ROOM_UNARCHIVED,
        USER_ADDED,
        USER_REMOVED,
        USER_JOINED,
        USER_LEFT,
        USER_MUTED,
        USER_UNMUTED,
        WELCOME,
        SUBSCRIPTION_ROLE_ADDED,
        SUBSCRIPTION_ROLE_REMOVED,
        OTHER;

    }
}

