/*
 * Decompiled with CFR 0.152.
 */
package com.rocketchat.core.model;

import org.json.JSONException;
import org.json.JSONObject;

public class MessageUrl {
    private String url;
    private Boolean ignoreParse;
    private Meta meta;
    private ParsedUrl parsedUrl;

    public MessageUrl(JSONObject object) {
        this.url = object.optString("url");
        this.ignoreParse = object.optBoolean("ignoreParse");
        try {
            if (object.opt("meta") != null) {
                this.meta = new Meta(object.getJSONObject("meta"));
            }
            if (object.opt("parsedUrl") != null) {
                this.parsedUrl = new ParsedUrl(object.getJSONObject("parsedUrl"));
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public String getUrl() {
        return this.url;
    }

    public Meta getMeta() {
        return this.meta;
    }

    public ParsedUrl getParsedUrl() {
        return this.parsedUrl;
    }

    public Boolean getIgnoreParse() {
        return this.ignoreParse;
    }

    public class ParsedUrl {
        private String host;
        private String hash;
        private String pathname;
        private String protocol;
        private Object port;
        private Object query;
        private Object search;
        private String hostname;

        public ParsedUrl(JSONObject object) {
            try {
                this.host = object.getString("host");
                this.hash = object.getString("hash");
                this.pathname = object.getString("pathname");
                this.protocol = object.getString("protocol");
                this.port = object.opt("port");
                this.query = object.opt("query");
                this.search = object.opt("search");
                this.hostname = object.optString("hostname");
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }

        public String getHost() {
            return this.host;
        }

        public String getHash() {
            return this.hash;
        }

        public String getPathname() {
            return this.pathname;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public Object getPort() {
            return this.port;
        }

        public Object getQuery() {
            return this.query;
        }

        public Object getSearch() {
            return this.search;
        }

        public String getHostname() {
            return this.hostname;
        }
    }

    public class Meta {
        private String pageTitle;
        private String fbAppId;
        private String description;
        private String ogImage;
        private String ogSiteName;
        private String ogType;
        private String ogTitle;
        private String ogUrl;
        private String ogDescription;

        public Meta(JSONObject object) {
            try {
                this.pageTitle = object.getString("pageTitle");
                this.fbAppId = object.getString("fbAppId");
                this.description = object.getString("description");
                this.ogImage = object.getString("ogImage");
                this.ogSiteName = object.getString("ogSiteName");
                this.ogType = object.getString("ogType");
                this.ogTitle = object.getString("ogTitle");
                this.ogUrl = object.getString("ogUrl");
                this.ogDescription = object.getString("ogDescription");
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }

        public String getPageTitle() {
            return this.pageTitle;
        }

        public String getFbAppId() {
            return this.fbAppId;
        }

        public String getDescription() {
            return this.description;
        }

        public String getOgImage() {
            return this.ogImage;
        }

        public String getOgSiteName() {
            return this.ogSiteName;
        }

        public String getOgType() {
            return this.ogType;
        }

        public String getOgTitle() {
            return this.ogTitle;
        }

        public String getOgUrl() {
            return this.ogUrl;
        }

        public String getOgDescription() {
            return this.ogDescription;
        }
    }
}

