/*
 * Decompiled with CFR 0.152.
 */
package com.rocketchat.core.model;

import java.util.Date;
import org.json.JSONException;
import org.json.JSONObject;

public class FileObject {
    private String fileId;
    private String fileName;
    private String description;
    private int size;
    private String fileType;
    private String roomId;
    private String extension;
    private String store;
    private Date uploadedAt;
    private Date updatedAt;
    private String url;

    public FileObject(JSONObject object) {
        try {
            this.fileId = object.optString("_id");
            this.fileName = object.optString("name");
            this.description = object.optString("description");
            this.size = object.optInt("size");
            this.fileType = object.optString("type");
            this.roomId = object.optString("rid");
            this.extension = object.optString("extension");
            this.store = object.optString("store");
            if (object.opt("_updatedAt") != null) {
                this.updatedAt = new Date(object.getJSONObject("_updatedAt").getLong("$date"));
            }
            if (object.opt("uploadedAt") != null) {
                this.uploadedAt = new Date(object.getJSONObject("uploadedAt").getLong("$date"));
            }
            this.url = object.optString("url");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public String getFileId() {
        return this.fileId;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getDescription() {
        return this.description;
    }

    public int getSize() {
        return this.size;
    }

    public String getFileType() {
        return this.fileType;
    }

    public String getRoomId() {
        return this.roomId;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getStore() {
        return this.store;
    }

    public Date getUploadedAt() {
        return this.uploadedAt;
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public String getUrl() {
        return this.url;
    }

    public String toString() {
        return "FileObject{fileId='" + this.fileId + '\'' + ", fileName='" + this.fileName + '\'' + ", description='" + this.description + '\'' + ", size=" + this.size + ", fileType='" + this.fileType + '\'' + ", roomId='" + this.roomId + '\'' + ", extension='" + this.extension + '\'' + ", store='" + this.store + '\'' + ", uploadedAt=" + this.uploadedAt + ", updatedAt=" + this.updatedAt + ", url='" + this.url + '\'' + '}';
    }
}

