/*
 * Decompiled with CFR 0.152.
 */
package com.rocketchat.common.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Observable;

public class MultipartUploader
extends Observable {
    private final String boundary;
    private static final String LINE_FEED = "\r\n";
    private HttpURLConnection httpConn;
    private String charset;
    private OutputStream outputStream;
    private PrintWriter writer;

    public MultipartUploader(String requestURL, String charset) throws IOException {
        this.charset = charset;
        this.boundary = "===" + System.currentTimeMillis() + "===";
        URL url = new URL(requestURL);
        this.httpConn = (HttpURLConnection)url.openConnection();
        this.httpConn.setUseCaches(false);
        this.httpConn.setDoOutput(true);
        this.httpConn.setDoInput(true);
        this.httpConn.setChunkedStreamingMode(4096);
        this.httpConn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + this.boundary);
        this.httpConn.setRequestProperty("User-Agent", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.109 Safari/537.36");
        this.outputStream = this.httpConn.getOutputStream();
        this.writer = new PrintWriter((Writer)new OutputStreamWriter(this.outputStream, charset), true);
    }

    public void addFormField(String name, String value) {
        this.writer.append("--" + this.boundary).append(LINE_FEED);
        this.writer.append("Content-Disposition: form-data; name=\"" + name + "\"").append(LINE_FEED);
        this.writer.append("Content-Type: text/plain; charset=" + this.charset).append(LINE_FEED);
        this.writer.append(LINE_FEED);
        this.writer.append(value).append(LINE_FEED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFilePart(String fieldName, File uploadFile) throws IOException {
        this.writer.append("--" + this.boundary).append(LINE_FEED);
        this.writer.append("Content-Disposition: form-data; name=\"" + fieldName + "\"").append(LINE_FEED);
        this.writer.append("Content-Type: application/octet-stream").append(LINE_FEED);
        this.writer.append("Content-Transfer-Encoding: binary").append(LINE_FEED);
        int totalSize = (int)uploadFile.length();
        try (FileInputStream inputStream = null;){
            inputStream = new FileInputStream(uploadFile);
            byte[] buffer = new byte[4096];
            int bytesRead = 0;
            int progress = 0;
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                this.outputStream.write(buffer, 0, bytesRead);
                this.outputStream.flush();
                this.setChanged();
                this.notifyObservers((progress += bytesRead) * 100 / totalSize);
            }
            this.writer.flush();
        }
    }

    public void addHeaderField(String name, String value) {
        this.writer.append(name + ": " + value).append(LINE_FEED);
        this.writer.flush();
    }

    public int finish() throws IOException {
        this.writer.append(LINE_FEED).flush();
        this.writer.append("--" + this.boundary + "--").append(LINE_FEED);
        this.writer.flush();
        int status = this.httpConn.getResponseCode();
        this.writer.close();
        this.httpConn.disconnect();
        return status;
    }
}

